import geometry.*;
import draw.*;
import colors.*;

import java.util.Random;

//to represent a blob on the canvas
public class Blob{

  /*
	;                                 
	;                                 
	;                                 
	;   ;;;;;  ;           ;          
	;   ;    ; ;           ;          
	;   ;    ; ;           ;          
	;   ;   ;  ;    ;;;    ; ;;       
	;   ;;;;   ;   ;   ;   ;;  ;      
	;   ;   ;  ;  ;     ;  ;    ;     
	;   ;    ; ;  ;     ;  ;    ;     
	;   ;    ; ;  ;     ;  ;    ;     
	;   ;    ; ;   ;   ;   ;;  ;      
	;   ;;;;;  ;    ;;;    ; ;;       
	;                                 
	;                                 
	;                                 
   */

  public Posn center;
  public int radius;

  Blob(Posn center, int radius) {
    this.center = center;
    this.radius = radius;
  }

  // draw this blob in the given World
  public boolean draw(World w) {
    return w.theCanvas.drawDisk(this.center, this.radius, new Red());
  } 

  // move this blob 20 pixels in the direction given by the ke
  public Blob moveBlob(String ke){
    if (ke.equals("right"))
      return new Blob(new Posn(this.center.x + 5, this.center.y), 
          this.radius);
    else if (ke.equals("left"))
      return new Blob(new Posn(this.center.x - 5, this.center.y), 
          this.radius);
    else if (ke.equals("up"))
      return new Blob(new Posn(this.center.x, this.center.y - 5), 
          this.radius);
    else if (ke.equals("down"))
      return new Blob(new Posn(this.center.x, this.center.y + 5), 
          this.radius);
    else
      return this;
  }

  // produce a new blob moved by a random distance < n pixels
  public Blob randomMove(int n){
    return new Blob(new Posn(this.center.x + this.randomInt(n),
        this.center.y + this.randomInt(n) ),
        this.radius);
  }

  // helper method to generate a random number in the range -n to n
  public int randomInt(int n){
    return -n + (new Random().nextInt(2 * n + 1));
  }

  // is the blob outside the bounds given by the width and height
  public boolean outsideBounds(int width, int height) {
    return this.center.x < 0
    || this.center.x > width
    || this.center.y < 0 
    || this.center.y > height;
  }
}


