import tester.*;

/* 
Lab 6: Spring 2008
Migrating to Java and Eclipse IDE
*/

/*
   +---------------+
   | Book          |
   +---------------+
   | String title  |
 +-| Author author |
 | | int year      |
 | +---------------+
 v
+-------------+
| Author      |
+-------------+
| String name |
| int dob     |
+-------------+

*/

// to represent a book
class Book{
  String title;
  Author author;
  int year;
  
  // the constructor
  Book(String title, Author author, int year){
    this.title = title;
    this.author = author;
    this.year = year;
  }
  
  // was this book published before the given year?
  boolean before(int year){
    return this.year < year;
  }
  
  // is the given name a name of this book's author 
  boolean isAuthor(String name){
    return this.author.sameName(name); 
  }
}

// to represent a book author
class Author {
  String name;
  int dob;

  Author(String name, int dob) {
    this.name = name;
    this.dob = dob;
  }
  
  // is the given name this author's name?
  boolean sameName(String name){
    return this.name.equals(name);
  }
}


//-----------------------------------------------------------------------------
//Examples class for the Book class
public class Examples implements IExamples{
 public Examples(){};
 
 Author pc = new Author("Pat", 1946);
 Author db = new Author("Dan", 1056);
 
 Book book1 = new Book("DVC", this.db, 2002); 
 Book book2 = new Book("Beach", this.pc, 1999);

 public void tests(Tester t){
  // tests for the method before in the class Book
  t.checkExpect(this.book1.before(2000), false, 
      "test 1 for the method before in the class Book");
  t.checkExpect(this.book2.before(2000), true, 
      "test 1 for the method before in the class Book");

  // tests for the method isAuthor in the class Book
  t.checkExpect(this.book1.isAuthor("Pat"),  false,
      "test 1 for the method isAuthor in the class Book");
  t.checkExpect(this.book2.isAuthor("Pat"),  true,
      "test 2 for the method isAuthor in the class Book");

  // tests for the method sameName in the class Author
  t.checkExpect(this.db.sameName("Pat"), false, 
      "tests for the method sameName in the class Author");
  t.checkExpect(this.pc.sameName("Pat"), true, 
      "tests for the method sameName in the class Author");
 }
}
