/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import tester.ErrorReport;
import tester.IExamples;
import tester.Inspector;
import tester.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tester {
    private String testResults = "Test results: \n";
    private String fullTestResults = "Full test results: \n";
    private int n = 0;
    private int errors = 0;
    private String testname = "";
    private Inspector inspector = new Inspector();

    public void runTests(IExamples f) {
        this.n = 0;
        boolean failed = false;
        System.out.println("Examples class:\n---------------");
        System.out.println(String.valueOf(Printer.produceString(f)) + "\n---------------");
        try {
            try {
                f.tests(this);
            }
            catch (Throwable e) {
                ++this.errors;
                System.out.println("Threw exception during test " + this.n);
                e.printStackTrace();
                failed = true;
                this.testReport();
                this.done(failed);
            }
        }
        finally {
            this.testReport();
            this.done(failed);
        }
    }

    private void done(boolean failed) {
        if (failed) {
            this.reportErrors(this.testname, "caused RuntimeException", "unkown");
        }
        if (this.errors > 0) {
            System.out.print("Failed " + this.errors + " out of ");
        } else {
            System.out.print("Passed all ");
        }
        System.out.println(String.valueOf(this.n) + " tests.");
    }

    public void setTolerance(double epsilon) {
        Inspector.TOLERANCE = epsilon;
    }

    public boolean same(Object obj1, Object obj2) {
        return this.inspector.isSame(obj1, obj2);
    }

    private void report(boolean success, String testname, Object actual, Object expected) {
        if (success) {
            this.reportSuccess(testname, actual, expected);
        } else {
            String trace = this.getStackTrace();
            this.reportErrors(String.valueOf(testname) + "\n" + trace, actual, expected);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getStackTrace() {
        try {
            throw new ErrorReport("Error trace:");
        }
        catch (ErrorReport e) {
            ste = e.getStackTrace();
            length = Array.getLength(ste);
            tmpSTE = new StackTraceElement[length];
            ui = 0;
            i = 3;
            ** while (i < length)
        }
lbl-1000:
        // 1 sources

        {
            cname = ste[i].getClassName();
            if (!cname.startsWith("tester.")) {
                tmpSTE[ui] = ste[i];
                ++ui;
            }
            ++i;
            continue;
        }
lbl16:
        // 1 sources

        userSTE = new StackTraceElement[ui];
        i = 0;
        while (i < ui) {
            userSTE[i] = tmpSTE[i];
            ++i;
        }
        e.setStackTrace(userSTE);
        writer = new StringWriter();
        printwriter = new PrintWriter(writer);
        e.printStackTrace(printwriter);
        return writer.toString();
    }

    public void checkExpect(boolean result) {
        this.checkExpect(result, "");
    }

    public void checkExpect(boolean result, String testname) {
        this.testname = testname;
        if (!result) {
            this.addError(String.valueOf(testname) + ": error -- no blame -- \n");
        } else {
            this.addSuccess(String.valueOf(testname) + ": success \n");
        }
    }

    public void checkExpect(boolean actual, boolean expected) {
        this.checkExpect(actual, expected, "");
    }

    public void checkExpect(boolean actual, boolean expected, String testname) {
        this.testname = testname;
        this.report(actual == expected, testname, "" + actual, "" + expected);
    }

    public <T> void checkExpect(T actual, T expected) {
        this.checkExpect(actual, expected, "");
    }

    public <T> void checkExpect(T actual, T expected, String testname) {
        this.testname = testname;
        this.report(this.inspector.isSame(actual, expected), testname, actual, expected);
    }

    public <T> void checkExpect(T object, String method, Object[] args, Exception e) {
        this.checkExpect(object, method, args, e, "");
    }

    public <T> void checkExpect(T object, String method, Object[] args, Exception e, String testname) {
        this.testname = testname;
        int length = Array.getLength(args);
        Class[] parameters = new Class[length];
        int i = 0;
        while (i < length) {
            parameters[i] = args[i].getClass();
            ++i;
        }
        Class<?> exceptClass = e.getClass();
        try {
            Method meth = object.getClass().getMethod(method, parameters);
            meth.setAccessible(true);
            Object result = meth.invoke(object, args);
            this.addError(String.valueOf(testname) + " : errors" + "\n invocation did not throw any exception " + "\n  method name: " + meth.getName() + "\n  object class: " + object.getClass().getName() + "\n  result: " + result.getClass().getName() + ": " + Printer.produceString(result) + "\n  expected exception was: \n    class: " + e.getClass().getName() + "\n    message: " + e.getMessage() + "\n\n");
        }
        catch (Throwable exception) {
            if (exception.getCause().getClass().getName().equals(exceptClass.getName())) {
                if (e.getMessage().equals(exception.getCause().getMessage())) {
                    this.addSuccess(String.valueOf(testname) + " : success" + "\n correct exception: \n class: " + exception.getCause().getClass().getName() + "\n correct message: " + exception.getCause().getMessage() + "\n\n");
                } else {
                    this.addError(String.valueOf(testname) + " : errors" + "\n correct exception: \n class: " + exception.getCause().getClass().getName() + "\n incorrect message: " + exception.getCause().getMessage() + "\n\n");
                }
            }
            this.addError(String.valueOf(testname) + " : errors" + "\n incorrect exception was thrown: " + "\n    class of the thrown exception: " + exception.getCause().getClass().getName() + "\n    class of the expected exception: " + e.getClass().getName() + "\n\n");
        }
    }

    public <T> void checkExpect(T object, String method, Object[] args, Object expected) {
        this.checkExpect(object, method, args, expected, "");
    }

    public <T> void checkExpect(T object, String method, Object[] args, Object expected, String testname) {
        this.testname = testname;
        int length = Array.getLength(args);
        Class[] parameters = new Class[length];
        String[] paraNames = new String[length];
        int i = 0;
        while (i < length) {
            parameters[i] = args[i].getClass();
            ++i;
        }
        String parlist = "(";
        int i2 = 0;
        while (i2 < length) {
            parlist = String.valueOf(parlist) + parameters[i2].getName() + ",";
            ++i2;
        }
        parlist = String.valueOf(parlist.substring(0, parlist.length() - 1)) + ")";
        try {
            Method meth = this.findMethod(object, method, parameters, testname);
            if (meth == null) {
                this.report(false, String.valueOf(testname) + "\nNo method with the name " + method + " found\n", "Failed to invoke method " + object.getClass().getName() + "." + method + parlist, expected);
            } else {
                meth.setAccessible(true);
                String testmessage = String.valueOf(testname) + "\n" + Printer.produceString(object) + "\n invoked method " + method + " in the class " + object.getClass().getName() + "\n with arguments " + Printer.produceString(args) + "\n";
                this.checkExpect(meth.invoke(object, args), expected, testmessage);
            }
        }
        catch (Throwable exception) {
            String testmessage = String.valueOf(testname) + "\n" + Printer.produceString(object) + "\n invoked method " + method + " in the class " + object.getClass().getName() + "\n with arguments " + Printer.produceString(args) + "\n";
            this.reportErrors(String.valueOf(testmessage) + "\nthrew an excception ", object, Printer.produceString(args));
            exception.printStackTrace();
        }
    }

    private <T> Method findMethod(T object, String method, Class[] parameters, String testname) {
        Method[] allMethods = object.getClass().getDeclaredMethods();
        ArrayList<Method> allNamed = new ArrayList<Method>();
        int i = 0;
        while (i < allMethods.length) {
            if (allMethods[i].getName().equals(method)) {
                allNamed.add(allMethods[i]);
            }
            ++i;
        }
        if (allNamed.size() > 0) {
            for (Method m : allNamed) {
                if (!this.matchParams(m.getParameterTypes(), parameters)) continue;
                return m;
            }
            testname = String.valueOf(testname) + "\nNo method with the name " + method + " had a matching argument list\n";
            return null;
        }
        testname = String.valueOf(testname) + "\nNo method with the name " + method + " found\n";
        return null;
    }

    private boolean matchParams(Class[] parInput, Class[] parDefined) {
        if (Array.getLength(parInput) != Array.getLength(parDefined)) {
            return false;
        }
        int i = 0;
        while (i < Array.getLength(parInput)) {
            String def;
            String in = parInput[i].getName();
            if (!in.equals(def = parDefined[i].getName()) && Inspector.isWrapperClass(def) && !this.isWrapperMatch(in, def)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isWrapperMatch(String in, String def) {
        if (def.equals("java.lang.Integer") && in.equals("int")) {
            return true;
        }
        if (def.equals("java.lang.Short") && in.equals("short")) {
            return true;
        }
        if (def.equals("java.lang.Long") && in.equals("long")) {
            return true;
        }
        if (def.equals("java.lang.Byte") && in.equals("byte")) {
            return true;
        }
        if (def.equals("java.lang.Character") && in.equals("char")) {
            return true;
        }
        if (def.equals("java.lang.Double") && in.equals("double")) {
            return true;
        }
        if (def.equals("java.lang.Float") && in.equals("float")) {
            return true;
        }
        if (def.equals("java.lang.Double") && in.equals("double")) {
            return true;
        }
        return def.equals("java.lang.Boolean") && in.equals("boolean");
    }

    private void reportErrors(String testname, Object actual, Object expected) {
        this.addError(String.valueOf(testname) + ": errors \n" + "actual: " + Printer.produceString(actual) + "\n" + "expected:   " + Printer.produceString(expected) + "\n");
    }

    private void reportSuccess(String testname, Object actual, Object expected) {
        this.addSuccess(String.valueOf(testname) + ": success \n" + "actual: " + Printer.produceString(actual) + "\n" + "expected:   " + Printer.produceString(expected) + "\n");
    }

    private void addSuccess(String testResult) {
        this.fullTestResults = String.valueOf(this.fullTestResults) + "\n" + testResult;
        ++this.n;
    }

    private void addError(String testResult) {
        this.testResults = String.valueOf(this.testResults) + "\n" + testResult;
        this.fullTestResults = String.valueOf(this.fullTestResults) + "\n" + testResult;
        ++this.n;
        ++this.errors;
    }

    public void testReport() {
        System.out.println(String.valueOf(this.testCount()) + this.testResults);
    }

    public void fullTestReport() {
        System.out.println(String.valueOf(this.testCount()) + this.fullTestResults);
    }

    private String testCount() {
        String tCount = "";
        if (this.n == 1) {
            tCount = "\nRan 1 test.\n";
        } else if (this.n > 1) {
            tCount = "\nRan " + this.n + " tests.\n";
        }
        if (this.errors == 0) {
            tCount = String.valueOf(tCount) + "All tests passed.\n\n";
        }
        if (this.errors == 1) {
            tCount = String.valueOf(tCount) + "1 test failed.\n\n";
        } else if (this.errors > 1) {
            tCount = String.valueOf(tCount) + this.errors + " tests failed.\n\n";
        }
        return tCount;
    }
}

