/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import tester.Inspector;
import tester.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflector {
    Object sample;
    Class sampleClass;
    Field[] sampleDeclaredFields;

    public Reflector(Object sample) {
        if (sample != null) {
            this.sample = sample;
            this.sampleClass = this.sample.getClass();
            this.sampleDeclaredFields = this.getFields(sample);
        }
    }

    public ArrayList<Class> getClasses(Object obj) {
        ArrayList<Class> classTower = new ArrayList<Class>();
        Class<?> c = obj.getClass();
        Package p = c.getPackage();
        String cPackageName = this.getPackageName(c);
        classTower.add(c);
        Class<?> sc = c.getSuperclass();
        if (!cPackageName.equals("Object Type") && !cPackageName.equals("Wrapper Class")) {
            String scPackageName = this.getPackageName(sc);
            while (cPackageName.equals(scPackageName) && !sc.getName().equals("java.lang.Object")) {
                scPackageName = this.getPackageName(sc);
                classTower.add(0, sc);
                sc = sc.getSuperclass();
            }
        }
        return classTower;
    }

    public String getPackageName(Class c) {
        if (c.getName().equals("Object")) {
            return "Object Type";
        }
        if (Inspector.isWrapperClass(c.getName())) {
            return "Wrapper Class";
        }
        if (c.getName().length() >= 4 && c.getName().substring(0, 4).equals("java")) {
            return "Java Library";
        }
        Package p = c.getPackage();
        if (p == null) {
            return "Default Package";
        }
        return p.getName();
    }

    public Field[] getFields(Object obj) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        ArrayList<Class> classTower = this.getClasses(obj);
        for (Class cl : classTower) {
            Field[] fields;
            Field[] fieldArray = fields = cl.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                f.setAccessible(true);
                if (!Modifier.isStatic(f.getModifiers()) || !f.getDeclaringClass().equals(cl)) {
                    allFields.add(f);
                }
                ++n2;
            }
        }
        Field[] allFieldsArray = new Field[allFields.size()];
        return allFields.toArray(allFieldsArray);
    }

    public void printInfo() {
        System.out.println("sample: " + this.sample);
        System.out.println("sampleClass: " + this.sampleClass);
        System.out.println("sampleDeclaredFields: \n");
        this.printSampleFields(this.sampleDeclaredFields);
    }

    protected void printSampleFields(Field[] fieldArray) {
        System.out.println("number of fields: " + Array.getLength(fieldArray) + "\n");
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray2[n2];
            Class<?> t = f.getType();
            System.out.println("field name = " + f.getName() + "\nfield  type = " + t.getName());
            try {
                System.out.println("field value = " + f.get(this.sample) + "\n");
            }
            catch (IllegalAccessException e) {
                System.out.println("printSampleFields cannot access the field  message: " + e.getMessage());
            }
            ++n2;
        }
    }

    protected Field findField(String fieldName) {
        Field[] fieldArray = this.sampleDeclaredFields;
        int n = this.sampleDeclaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getName().equals(fieldName)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    protected void show(String fieldName) {
        Field f = this.findField(fieldName);
        if (f == null) {
            System.out.println("Object " + fieldName + " is not declared in this class.");
        } else {
            try {
                System.out.println("this." + fieldName + " = " + Printer.produceString(f.get(this.sample)));
            }
            catch (IllegalAccessException e) {
                System.out.println("the field " + f.getName() + " cannot be shown \n" + " message: " + e.getMessage());
            }
        }
    }

    protected Field findFieldWithValue(Object fieldValue) {
        Field[] fieldArray = this.sampleDeclaredFields;
        int n = this.sampleDeclaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                if (f.get(this.sample).equals(fieldValue)) {
                    return f;
                }
            }
            catch (IllegalAccessException e) {
                System.out.println("findFieldWithValue cannot access the field " + f.getName() + " of the class " + this.sampleClass.getName() + "\n   message: " + e.getMessage());
            }
            ++n2;
        }
        return null;
    }

    protected void showFieldWithValue(Object fieldValue) {
        Field f = this.findFieldWithValue(fieldValue);
        if (f == null) {
            System.out.println("Object " + fieldValue + " is not declared in this class.");
        } else {
            try {
                System.out.println("this." + f.getName() + " = " + Printer.produceString(f.get(this.sample)));
            }
            catch (IllegalAccessException e) {
                System.out.println("the field " + f.getName() + "cannot be shown \n" + " message: " + e.getMessage());
            }
        }
    }
}

