/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import tester.ISame;
import tester.Reflector;

public class Inspector {
    public static double TOLERANCE = 0.001;
    public static String INDENT = "  ";
    private HashMap<Integer, Integer> hashmap = new HashMap();

    public boolean isSame(Object obj1, Object obj2) {
        Reflector r1 = new Reflector(obj1);
        Reflector r2 = new Reflector(obj2);
        if (r1.sample == null) {
            return r2.sample == null;
        }
        if (r2.sample == null) {
            return false;
        }
        boolean sameClass = r1.sampleClass.equals(r2.sampleClass);
        if (sameClass) {
            if (r1.sampleClass.getName().equals("java.lang.String")) {
                return obj1.equals(obj2);
            }
            if (r1.sampleClass.getName().equals("java.awt.Color") || r1.sampleClass.getName().equals("colors.AColor") || r1.sampleClass.getName().equals("colors.Red") || r1.sampleClass.getName().equals("colors.Blue") || r1.sampleClass.getName().equals("colors.Green") || r1.sampleClass.getName().equals("colors.Yellow") || r1.sampleClass.getName().equals("colors.White") || r1.sampleClass.getName().equals("colors.Black")) {
                return ((Color)obj1).getRGB() == ((Color)obj2).getRGB();
            }
            if (r1.sampleClass.isPrimitive()) {
                if (this.isDouble(r1.sampleClass.getName())) {
                    return this.isSameDouble((Double)obj1, (Double)obj2);
                }
                if (this.isFloat(r1.sampleClass.getName())) {
                    return this.isSameFloat(((Float)obj1).floatValue(), ((Float)obj2).floatValue());
                }
                return obj1.equals(obj2);
            }
            if (Inspector.isWrapperClass(r1.sampleClass.getName())) {
                if (this.isDouble(r1.sampleClass.getName())) {
                    return this.isSameDouble((Double)obj1, (Double)obj2);
                }
                if (this.isFloat(r1.sampleClass.getName())) {
                    return this.isSameFloat(((Float)obj1).floatValue(), ((Float)obj2).floatValue());
                }
                return obj1.equals(obj2);
            }
            Integer i1 = obj1.hashCode();
            Integer i2 = obj2.hashCode();
            Integer i2match = this.hashmap.get(i1);
            if (i2match != null && i2match.equals(i2)) {
                return true;
            }
            this.hashmap.put(i1, i2);
            if (obj1 instanceof Object[] && obj2 instanceof Object[]) {
                int length = Array.getLength(obj1);
                if (Array.getLength(obj2) == length) {
                    int i = 0;
                    while (i < length) {
                        if (!this.isSame(((Object[])obj1)[i], ((Object[])obj2)[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
            if (obj1 instanceof ISame && obj2 instanceof ISame) {
                return ((ISame)obj1).same((ISame)obj2);
            }
            if (obj1 instanceof Iterable && obj2 instanceof Iterable) {
                return this.isSameIterable((Iterable)obj1, (Iterable)obj2);
            }
            boolean sameValues = true;
            int i = 0;
            try {
                while (i < Array.getLength(r1.sampleDeclaredFields)) {
                    sameValues = sameValues && this.isSame(r1.sampleDeclaredFields[i].get(obj1), r2.sampleDeclaredFields[i].get(obj2));
                    ++i;
                }
            }
            catch (IllegalAccessException e) {
                System.out.println("same comparing " + r1.sampleDeclaredFields[i].getType().getName() + " and " + r2.sampleDeclaredFields[i].getType().getName() + "cannot access the field " + i + " message: " + e.getMessage());
                System.out.println("class 1: " + r1.sampleClass.getName());
                System.out.println("class 2: " + r2.sampleClass.getName());
            }
            return sameValues;
        }
        return false;
    }

    public boolean isSameDouble(double d1, double d2) {
        if (d1 - d2 == 0.0) {
            return true;
        }
        return Math.abs(d1 - d2) / Math.max(Math.abs(d1), Math.abs(d2)) < TOLERANCE;
    }

    public boolean isSameFloat(float f1, float f2) {
        if ((double)(f1 - f2) == 0.0) {
            return true;
        }
        Double d1 = Float.valueOf(f1).doubleValue();
        Double d2 = Float.valueOf(f2).doubleValue();
        return Math.abs(d1 - d2) / Math.max(Math.abs(d1), Math.abs(d2)) < TOLERANCE;
    }

    public boolean isSameIterable(Iterable obj1, Iterable obj2) {
        Iterator it1 = obj1.iterator();
        Iterator it2 = obj2.iterator();
        return this.isSameData(it1, it2);
    }

    public boolean isSameData(Iterator it1, Iterator it2) {
        if (!it1.hasNext()) {
            return !it2.hasNext();
        }
        if (!it2.hasNext()) {
            return false;
        }
        return this.isSame(it1.next(), it2.next()) && this.isSameData(it1, it2);
    }

    public boolean isDouble(String name) {
        return name.equals("double") || name.equals("java.lang.Double");
    }

    public boolean isFloat(String name) {
        return name.equals("float") || name.equals("java.lang.Float");
    }

    public static boolean isWrapperClass(String name) {
        return name.equals("java.lang.Integer") || name.equals("java.lang.Long") || name.equals("java.lang.Short") || name.equals("java.math.BigInteger") || name.equals("java.math.BigDecimal") || name.equals("java.lang.Float") || name.equals("java.lang.Double") || name.equals("java.lang.Byte") || name.equals("java.lang.Boolean") || name.equals("java.lang.Character");
    }
}

