/** 
 * Examples class 
 * @author Bryan Chadwick
 * */

import java.util.ArrayList;
import java.util.Comparator;


//Tests and Examples
class StringExamples {
  // Generate a random list of Strings of given size using max for a bound
  //   on the actual numbers generated
  static ArrayList<String> fillDataString(int size, int max){
    ArrayList<String> list = new ArrayList<String>(size);
    for(int i = 0; i < size; i++)
      list.add(randomString(max));
    return list;
  }
  
  static String randomString(int top){
    String a = "a";
    String[] alpha = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", 
                                  "j", "k", "l", "m", "n", "o", "p", "q", "r", 
                                  "s", "t", "u", "v", "w", "x", "y", "z"};
    String tmp = "";
    int length = 1 + randomInt(15);
    for (int i = 1; i < length; i++){
      tmp = tmp.concat(alpha[randomInt(26)]);
    }
    return tmp;
  }
  

  // Return a nice random Integer between: [0, top)
  static Integer randomInt(int top){ return new Integer(Algorithms.randInt(0, top));}

  // Wrapper for System.out.println
  public static void println(String s){ print(s+'\n'); }
  // Wrapper for System.out.print
  public static void print(String s){ System.out.print(s); }



  // Normal main(...) for running Tests
  public static void main(String[] args) {
    // Number of times to run our timings
    //   'final' means we can't change (mutate) these ints
    final int loops = 0, 
    runs = 100;

    // Current size of the lists being sorted
    int size = 64;

    Comparator<String> comp = null;

    // Easy visual sort tests
    simpleTest(new Insert<String>(), comp);
    simpleTest(new Quick<String>(), comp);

    
    // Setting up the one for AList has to be done separately
    ArrayList<String> list = fillDataString(10, 40);
    println("          Start\t: "+list);
    InsertList<String> listsorter = new InsertList<String>();
    AList<String> alist = listsorter.sort(listsorter.fillList(list), comp);
    println("Sort("+listsorter.name+")\t: "+listsorter.result(alist));
    
    
    // Print out the Timings for each of the sorts in a kind of table
    println("\nTimings:");
    println(" N\tInsert\tQuick\tIns-List");
    for(int j = 0; j < loops; j++){
      print(" "+size+"\t  ");
      print(timeSort(new Insert<String>(), runs, size, comp)+"\t  ");
      print(""+timeSort(new Quick<String>(), runs, size, comp)+"\t  ");
      println(""+timeSortList(new InsertList<String>(), runs, size, comp));
      size *= 2;
    }        
  }

  // Abstract Test methods in case I add more Sorters
  // Visual check of the sorter methods for randomly generated list of integers
  static void simpleTest(Sorter<String> sorter, Comparator<String> comp){        
    ArrayList<String> list = fillDataString(10, 40);
    println("          Start\t: "+list);
    sorter.sort(list, comp);
    println("   Sort("+sorter.name+")\t: "+list);        
  }

  // Timing of a number of runs of a sorter method
  static long timeSort(Sorter<String> sorter, int runs, int size, Comparator<String> comp){
    ArrayList<String> list;
    long total = 0;
    Timing time;

    for(int i = 0; i < runs; i++){
      list = fillDataString(size, 1000);
      time = new Timing();
      sorter.sort(list, comp);
      total += time.diff();
    }
    return total;
  }


  // Timing of a number of runs of a sorter method for the AList
  static long timeSortList(InsertList<String> isorter, int runs, 
      int size, Comparator<String> comp){
    // first fill the ArryaList with data as in the ArrayList case
    ArrayList<String> list;

    // copy the data to an Alist before running the timer test
    AList<String> alist;
    long total = 0;
    Timing time;

    for(int i = 0; i < runs; i++){
      list = fillDataString(size, 1000);
      alist = isorter.fillList(list);
      time = new Timing();
      isorter.sort(alist, comp);
      total += time.diff();
    }
    return total;
  }
}
