/** 
 * Sorter class 
 * @author Bryan Chadwick and Viera K. Proulx
 * */

import java.util.ArrayList;
import java.util.Comparator;


//Abstract a little, so I can write my Test/Print functions without
//relying one a specific sorting algorithm
public abstract class Sorter<T>{
  String name;
  Sorter(String n){ name = n; }
  abstract void sort(ArrayList<T> list, Comparator<T> comp);
}

//Wraps Algorithm's insertionSort
class Insert<T> extends Sorter<T>{
  Insert(){ super("insert"); }
  void sort(ArrayList<T> list, Comparator<T> comp){ 
    Algorithms.insertionSort(list, comp);
  }
}

//Wraps Algorithm's quickSort
class Quick<T> extends Sorter<T>{
  Quick(){ super("quick"); }
  void sort(ArrayList<T> list, Comparator<T> comp){
    Algorithms.quickSort(list, comp);
  }
}

// Wraps Algorithm's insertion sort for lists, but requires AList data
class InsertList<T>{
  String name = "ins-list"; 
  AList<T> sort(AList<T> alist, Comparator<T> comp){
    return Algorithms.insertionSortList(alist, comp);
  }

  // Convert the data in ArrayList to AList
  AList<T> fillList(ArrayList<T> data){
    AList<T> result = new MT<T>();
    for (T item: data){
      result = new Cons<T>(item, result);
    }
    return result;
  }
  
  // convert the resulting AList back to ArrayList
  ArrayList<T> result(AList<T> alist){
    ArrayList<T> tmp = new ArrayList<T>();
    while (alist instanceof Cons){
      tmp.add(((Cons<T>)alist).first);
      alist = ((Cons<T>)alist).rest;
    }
    return tmp;
  }
}
