/** 
 * Examples class 
 * @author Bryan Chadwick
 * */

import java.util.ArrayList;
import java.util.Comparator;


//Tests and Examples
class Examples {
  // Generate a random list of integers of given size using max for a bound
  //   on the actual numbers generated
  static ArrayList<Integer> fillData(int size, int max){
    ArrayList<Integer> list = new ArrayList<Integer>(size);
    for(int i = 0; i < size; i++)
      list.add(randomInt(max));
    return list;
  }

  // Return a nice random Integer between: [0, top)
  static Integer randomInt(int top){ return new Integer(Algorithms.randInt(0, top));}

  // Wrapper for System.out.println
  public static void println(String s){ print(s+'\n'); }
  // Wrapper for System.out.print
  public static void print(String s){ System.out.print(s); }



  // Normal main(...) for running Tests
  public static void main(String[] args) {
    // Number of times to run our timings
    //   'final' means we can't change (mutate) these ints
    final int loops = 0, 
    runs = 100;

    // Current size of the lists being sorted
    int size = 64;

    Comparator<Integer> comp = null;

    // Easy visual sort tests
    simpleTest(new Insert<Integer>(), comp);
    simpleTest(new Quick<Integer>(), comp);

    // Setting up the one for AList has to be done separately
    ArrayList<Integer> list = fillData(10, 40);
    println("          Start\t: "+list);
    InsertList<Integer> listsorter = new InsertList<Integer>();
    AList<Integer> alist = listsorter.sort(listsorter.fillList(list), comp);
    println("Sort("+listsorter.name+")\t: "+listsorter.result(alist));

    // Print out the Timings for each of the sorts in a kind of table
    println("\nTimings:");
    println(" N\tInsert\tQuick\tIns-List");
    for(int j = 0; j < loops; j++){
      print(" "+size+"\t  ");
      print(timeSort(new Insert<Integer>(), runs, size, comp)+"\t  ");
      print(""+timeSort(new Quick<Integer>(), runs, size, comp)+"\t  ");
      println(""+timeSortList(new InsertList<Integer>(), runs, size, comp) + "...");
      size *= 2;
    }        
  }

  // Abstract Test methods in case I add more Sorters
  // Visual check of the sorter methods for randomly generated list of integers
  static void simpleTest(Sorter<Integer> sorter, Comparator<Integer> comp){        
    ArrayList<Integer> list = fillData(10, 40);
    println("          Start\t: "+list);
    sorter.sort(list, comp);
    println("   Sort("+sorter.name+")\t: "+list);        
  }

  // Timing of a number of runs of a sorter method
  static long timeSort(Sorter<Integer> sorter, int runs, int size, Comparator<Integer> comp){
    ArrayList<Integer> list;
    long total = 0;
    Timing time;

    for(int i = 0; i < runs; i++){
      list = fillData(size, 1000);
      time = new Timing();
      sorter.sort(list, comp);
      total += time.diff();
    }
    return total;
  }


  // Timing of a number of runs of a sorter method for the AList
  static long timeSortList(InsertList<Integer> isorter, int runs, 
      int size, Comparator<Integer> comp){
    // first fill the ArryaList with data as in the ArrayList case
    ArrayList<Integer> list;

    // copy the data to an Alist before running the timer test
    AList<Integer> alist;
    long total = 0;
    Timing time;

    for(int i = 0; i < runs; i++){
      list = fillData(size, 1000);
      alist = isorter.fillList(list);
      time = new Timing();
      isorter.sort(alist, comp);
      total += time.diff();
    }
    return total;
  }
}
