import java.util.*;

import tester.*;

/**
 * The test suite for the US map exploration and Lab 11 Spring 2008
 * 
 * @author Viera K. Proulx
 *
 */
public class Examples implements IExamples{
  
  /** data for the methods and tests */
  HashMap<City, State> newEngland = new HashMap<City, State>();
  ArrayList<String> NHneighbors = new ArrayList<String>();
  ArrayList<String> VTneighbors = new ArrayList<String>();
  ArrayList<String> MEneighbors = new ArrayList<String>();
  
  City concord = new City("03301", "Concord", "NH", 71.527734, 43.218525);
  City montpellier = new City("05602", "Montpelier", "VT", 72.576992, 44.264082);
  City augusta = new City("04330", "Augusta", "ME", 69.766548, 44.323228);

  
  State NH = new State("NH", concord, NHneighbors );
  State VT = new State("VT", montpellier, VTneighbors );
  State ME = new State("ME", augusta, MEneighbors );
  
  
  /** generate lists of neighboring states */
  public void makeNewEngland(){
    NHneighbors.add("ME");
    NHneighbors.add("MA");
    NHneighbors.add("VT");
    
    VTneighbors.add("NH");
    VTneighbors.add("MA");

    MEneighbors.add("NH");
  }
  
  /** generate New England states */
  public void makeStates(){
    
    newEngland.put(concord, NH);
    newEngland.put(montpellier, VT);
    newEngland.put(augusta, ME);
  }

  ArrayList<City> cities = new ArrayList<City>();

  /** initialize cities with the data from a file */
  public void initCities(){
    Traversal<City> tr = new InFileCityTraversal();

    try{
      while (!tr.isEmpty()){
        cities.add(tr.getFirst());
        tr= tr.getRest();
      }
    }
    catch(IllegalUseOfTraversalException e){
      System.out.println(
          "IllegalUseOfTraversalException: cannot happen" +
          e.getMessage());
    } 
  }
  
  /**
   * The test driver
   */
  public void tests(Tester t){
    this.makeNewEngland();
    this.makeStates();
    
    System.out.println("After initialization:");
    System.out.println("Concord: " + newEngland.get(concord));
    System.out.println("Montpellier: " + newEngland.get(montpellier));
    System.out.println("Augusta: " + newEngland.get(augusta));
    
    initCities();
    for (City c: cities){
      System.out.println(c.toString());
    }
  }
  
  
}