import java.util.ArrayList; 

class ALTTests { 
  // Students 
  Student skotthe = new Student("Theo", "A", 1234); 
  Student chadwick = new Student("Bryan", "B", 3456); 
  Student dimvar = new Student("Dimitris", "C", 7890); 
  Student chrdimo = new Student("Christos", "D", 1122); 
  Student mthomas = new Student("Mike", "A", 3344); 

  // ArrayLists 
  ArrayList<Student> al0; 
  ArrayList<Student> al1; 
  ArrayList<Student> al2;
  ArrayList<Student> al3;
  ArrayList<Student> al4;
  ArrayList<Student> al5;

  // ALTS
  ALT<Student> altMt = new ALT<Student>(al0);
  ALT<Student> alt1 = new ALT<Student>(al1); 
  ALT<Student> alt2 = new ALT<Student>(al2); 
  ALT<Student> alt3 = new ALT<Student>(al3); 
  ALT<Student> alt4 = new ALT<Student>(al4); 
  ALT<Student> alt5 = new ALT<Student>(al5); 


  public void resetData(){ 
    al0 = new ArrayList<Student>(); 
    al1 = new ArrayList<Student>(); 
    al1.add(skotthe); 

    al2 = new ArrayList<Student>(); 
    al2.add(skotthe); 
    al2.add(chadwick); 

    al3 = new ArrayList<Student>(); 
    al3.add(skotthe); 
    al3.add(chadwick); 
    al3.add(dimvar); 

    al4 = new ArrayList<Student>(); 
    al4.add(skotthe); 
    al4.add(chadwick); 
    al4.add(dimvar); 
    al4.add(chrdimo); 

    al5 = new ArrayList<Student>(); 
    al5.add(skotthe); 
    al5.add(chadwick); 
    al5.add(dimvar); 
    al5.add(chrdimo); 
    al5.add(mthomas); 

    // ALTS
    altMt = new ALT<Student>(new ArrayList<Student>()); 
    alt1 = new ALT<Student>(al1); 
    alt2 = new ALT<Student>(al2); 
    alt3 = new ALT<Student>(al3); 
    alt4 = new ALT<Student>(al4); 
    alt5 = new ALT<Student>(al5); 
  } 

  public static void main(String[] args){ 
    ALTTests altt = new ALTTests(); 
    altt.resetData(); 
    altt.runTests(); 
    altt.runOrMapTests(); 
    altt.bigStringTests(); 
    altt.bigStringWhileTests(); 
    altt.bigStringForTests(); 
    altt.bigStringForALTests(); 
    altt.bigStringWhileALTests(); 
  } 

  public void bigStringWhileTests() { 
    resetData();
    System.out.println(" ==== Testing bigStringWhile  ===="); 
    System.out.println("altMt = " + altMt.toString()); 
    System.out.println("altMt.bigStringWhile = " + altMt.bigStringWhile(altMt)); 

    System.out.println("alt1 = " + alt1.toString()); 
    System.out.println("alt1.bigStringWhile = " + alt1.bigStringWhile(alt1));
    
    System.out.println("alt2 = " + alt2.toString()); 
    System.out.println("alt2.bigStringWhile = " + alt2.bigStringWhile(alt2));
   
    System.out.println("alt3 = " + alt3.toString()); 
    System.out.println("alt3.bigStringWhile = " + alt3.bigStringWhile(alt3));
  
    System.out.println("alt4 = " + alt4.toString()); 
    System.out.println("alt4.bigStringWhile = " + alt4.bigStringWhile(alt4));
 
    System.out.println("alt5 = " + alt5.toString()); 
    System.out.println("alt5.bigStringWhile = " + alt5.bigStringWhile(alt5));

  } 

  public void bigStringForTests() { 
    resetData();

    System.out.println(" ==== Testing bigStringFor  ===="); 
    System.out.println("altMt = " + altMt.toString()); 
    System.out.println("altMt.bigStringFor = " + altMt.bigStringFor(altMt)); 

    System.out.println("alt1 = " + alt1.toString()); 
    System.out.println("alt1.bigStringFor = " + alt1.bigStringFor(alt1));
    
    System.out.println("alt2 = " + alt2.toString()); 
    System.out.println("alt2.bigStringFor = " + alt2.bigStringFor(alt2));
   
    System.out.println("alt3 = " + alt3.toString()); 
    System.out.println("alt3.bigStringFor = " + alt3.bigStringFor(alt3));
  
    System.out.println("alt4 = " + alt4.toString()); 
    System.out.println("alt4.bigStringFor = " + alt4.bigStringFor(alt4));
 
    System.out.println("alt5 = " + alt5.toString()); 
    System.out.println("alt5.bigStringFor = " + alt5.bigStringFor(alt5));
 
  } 

  public void bigStringWhileALTests() { 
    resetData();

    System.out.println(" ==== Testing bigStringWhileAL  ===="); 
    System.out.println("altMt = " + altMt.toString()); 
    System.out.println("altMt.bigStringWhileAL = " + altMt.bigStringWhileAL(al0)); 

    System.out.println("alt1 = " + alt1.toString()); 
    System.out.println("alt1.bigStringWhileAL = " + alt1.bigStringWhileAL(al1));
    
    System.out.println("alt2 = " + alt2.toString()); 
    System.out.println("alt2.bigStringWhileAL = " + alt2.bigStringWhileAL(al2));
   
    System.out.println("alt3 = " + alt3.toString()); 
    System.out.println("alt3.bigStringWhileAL = " + alt3.bigStringWhileAL(al3));
  
    System.out.println("alt4 = " + alt4.toString()); 
    System.out.println("alt4.bigStringWhileAL = " + alt4.bigStringWhileAL(al4));
 
    System.out.println("alt5 = " + alt5.toString()); 
    System.out.println("alt5.bigStringWhileAL = " + alt5.bigStringWhileAL(al5));
 
  } 

  public void bigStringForALTests() { 
    resetData();

    System.out.println(" ==== Testing bigStringForAl  ===="); 
    System.out.println("altMt = " + altMt.toString()); 
    System.out.println("altMt.bigStringForAl = " + altMt.bigStringForAL(al0)); 

    System.out.println("alt1 = " + alt1.toString()); 
    System.out.println("alt1.bigStringForAl = " + alt1.bigStringForAL(al1));
    
    System.out.println("alt2 = " + alt2.toString()); 
    System.out.println("alt2.bigStringForAl = " + alt2.bigStringForAL(al2));
   
    System.out.println("alt3 = " + alt3.toString()); 
    System.out.println("alt3.bigStringForAl = " + alt3.bigStringForAL(al3));
  
    System.out.println("alt4 = " + alt4.toString()); 
    System.out.println("alt4.bigStringForAl = " + alt4.bigStringForAL(al4));
 
    System.out.println("alt5 = " + alt5.toString()); 
    System.out.println("alt5.bigStringForAl = " + alt5.bigStringForAL(al5));
 
  } 

  public void bigStringTests(){ 
    resetData(); 

    System.out.println(" ==== Testing bigString  ===="); 
    System.out.println("altMt = " + altMt.toString()); 
    System.out.println("altMt.bigString = " + altMt.bigString(altMt)); 

    System.out.println("alt1 = " + alt1.toString()); 
    System.out.println("alt1.bigString = " + alt1.bigString(alt1));
    
    System.out.println("alt2 = " + alt2.toString()); 
    System.out.println("alt2.bigString = " + alt2.bigString(alt2));
   
    System.out.println("alt3 = " + alt3.toString()); 
    System.out.println("alt3.bigString = " + alt3.bigString(alt3));
  
    System.out.println("alt4 = " + alt4.toString()); 
    System.out.println("alt4.bigString = " + alt4.bigString(alt4));
 
    System.out.println("alt5 = " + alt5.toString()); 
    System.out.println("alt5.bigString = " + alt5.bigString(alt5));
  } 

  public void runOrMapTests(){
    resetData(); 

    InLabA inLabA = new InLabA(); 

    System.out.println(" ==== Testing OrMap  ===="); 
    System.out.println("altMt = " + altMt.toString()); 
    System.out.println("altMt.orMap = " + altMt.orMap(altMt,inLabA)); 

    System.out.println("alt1 = " + alt1.toString()); 
    System.out.println("alt1.orMap = " + alt1.orMap(alt1,inLabA)); 
 
    System.out.println("alt2 = " + alt2.toString()); 
    System.out.println("alt2.orMap = " + alt2.orMap(alt2,inLabA)); 
 
    System.out.println("alt3 = " + alt3.toString()); 
    System.out.println("alt3.orMap = " + alt3.orMap(alt3,inLabA)); 
 
    System.out.println("alt4 = " + alt4.toString()); 
    System.out.println("alt4.orMap = " + alt4.orMap(alt4,inLabA)); 
 
    System.out.println("alt5 = " + alt5.toString()); 
    System.out.println("alt5.orMap = " + alt5.orMap(alt5,inLabA)); 
 
  }

  public void runTests() { 
    resetData(); 
    //Run
    System.out.println(" ==== Testing altMt ===="); 
    System.out.println("altMt = " + altMt.toString()); 
    System.out.println("altMt.isEmpty = " + altMt.isEmpty()); 

    System.out.println(" ==== Testing alt1 ===="); 
    System.out.println("alt1 = " + alt1.toString()); 
    System.out.println("alt1.isEmpty = " + alt1.isEmpty()); 
    System.out.println("alt1.getFirst = " + alt1.getFirst().toString()); 
    System.out.println("alt1.getRest = " + alt1.getRest().toString()); 

    System.out.println(" ==== Testing alt2 ===="); 
    System.out.println("alt2 = " + alt2.toString()); 
    System.out.println("alt2.isEmpty = " + alt2.isEmpty()); 
    System.out.println("alt2.getFirst = " + alt2.getFirst().toString()); 
    System.out.println("alt2.getRest = " + alt2.getRest().toString()); 

    System.out.println(" ==== Testing alt3 ===="); 
    System.out.println("alt3 = " + alt3.toString()); 
    System.out.println("alt3.isEmpty = " + alt3.isEmpty()); 
    System.out.println("alt3.getFirst = " + alt3.getFirst().toString()); 
    System.out.println("alt3.getRest = " + alt3.getRest().toString()); 

    System.out.println(" ==== Testing alt4 ===="); 
    System.out.println("alt4 = " + alt4.toString()); 
    System.out.println("alt4.isEmpty = " + alt4.isEmpty()); 
    System.out.println("alt4.getFirst = " + alt4.getFirst().toString()); 
    System.out.println("alt4.getRest = " + alt4.getRest().toString()); 

    System.out.println(" ==== Testing alt5 ===="); 
    System.out.println("alt5 = " + alt5.toString()); 
    System.out.println("alt5.isEmpty = " + alt5.isEmpty()); 
    System.out.println("alt5.getFirst = " + alt5.getFirst().toString()); 
    System.out.println("alt5.getRest = " + alt5.getRest().toString()); 
  } 
} 
