import java.util.ArrayList; 

class ALT<T> implements Traversal<T> { 
  ArrayList<T> al; 
  int first; 

  public ALT(ArrayList<T> al){ 
    this.al = al; 
    this.first = 0;
  } 

  // Used inside ALT only!
  private ALT(ArrayList<T> al, int first) { 
    this.al = al; 
    this.first = first; 
  } 

  // Traversal<T> methods 
  public T getFirst() { return al.get(this.first); } 
  public boolean isEmpty() { return this.first == al.size(); } 
  public Traversal<T> getRest() { return new ALT<T>(this.al, first + 1); } 

  public <T> boolean orMap(Traversal<T> tr, ISelect<T> pick){ 
    return orMapAcc(tr, pick, false); 
  } 

  // using pick walk over tr calling pick on each element and or the results
  private <T> boolean orMapAcc(Traversal<T> tr, ISelect<T> pick, boolean acc){ 
    if(tr.isEmpty())
      return acc; 
    else return orMapAcc(tr.getRest(),pick,updateOrMapAcc(tr.getFirst(), pick, acc)); 
  } 

  private <T> boolean updateOrMapAcc(T ele, ISelect<T> pick, boolean acc){ 
    return pick.select(ele) || acc ; 
  } 


  // Concat all Student names in tr into one big string
  public String bigString(Traversal<Student> tr) { 
    return bigStringAcc(tr, ""); 
  } 

  // acc = Big string with all student names seen thus far
  private String bigStringAcc(Traversal<Student> tr, String acc){ 
    if (tr.isEmpty()) 
      return acc;
    else 
      return bigStringAcc(tr.getRest(), updateBigStringAcc(tr.getFirst(), acc)); 
  } 

  private String updateBigStringAcc(Student s, String acc){ 
    return acc.concat(s.name); 
  } 

  private String updateToStringAcc(T ele, String acc){ 
    return acc.concat("\n\t" + ele.toString()); 
  }

  public String bigStringWhile(Traversal<Student> tr){ 
    String acc= " "; // Base Value 
    while(!tr.isEmpty()){ 
      acc = updateBigStringAcc(tr.getFirst(), acc); 
      tr = tr.getRest(); 
    } 
    return acc; 
  } 

  public String bigStringFor(Traversal<Student> tr){ 
    String acc= " "; // Base Value 
    for( ; !tr.isEmpty(); tr = tr.getRest()){ 
      acc = updateBigStringAcc(tr.getFirst(), acc); 
    } 
    return acc; 
  } 

  public String bigStringForAL (ArrayList<Student> al) { 
    String acc = " "; // Base Value
    for (int index = 0; 0 <= index && index < al.size(); index = index + 1){ 
      acc = updateBigStringAcc(al.get(index), acc); 
    } 
    return acc; 
  } 


  public String bigStringWhileAL (ArrayList<Student> al) { 
    String acc = " "; // Base Value
    int index = 0; 
    while( 0 <= index && index < al.size()){ 
      acc = updateBigStringAcc(al.get(index), acc); 
      index = index + 1; 
    } 
    return acc; 
  } 


  public String toString(){ 
    String acc = " "; // representation of ATL as a string up to now
    for(int index = first; 0 <= index && index < al.size(); index++){ 
      acc = updateToStringAcc(al.get(index), acc); 
    }
    return acc; 
  } 
} 
