import draw.*;
import geometry.*;
import colors.*;

//TimerWorld.java

import java.util.Random;


//------------------------------------------------------------------------------
//represent the world of a Blob
public class TimerWorld extends World {
  
  int width = 200;
  int height = 400;
  Blob blob;
  
  public TimerWorld(Blob blob) {
    super();
    this.blob = blob;
  }
  
  // what happens when the player presses a key
  public World onKeyEvent(String ke) {
    return new TimerWorld(this.blob.moveBlob(ke));
  }
  
  // what happens when the clock ticks
  public World onTick() {
    // if the blob is outside the canvas, stop
    if (this.blob.outsideBounds(this.width, this.height))
      return this.endOfWorld();
    
    // else move the blob randomly at most 5 pixels in any direction
    else
      return new TimerWorld(this.blob.randomMove(5));
  }
  
  // draw this world
  public boolean draw() {
    return this.theCanvas.drawRect(new Posn(0, 0), this.width, this.height, new Blue())
    && this.blob.draw(this);
  }
  
  // erase this world
  public boolean erase() {
    return this.theCanvas.drawRect(new Posn(0, 0), this.width, this.height, new Blue());
  }
  
}

