/** 
 * Timing class 
 * @author Bryan Chadwick
 * */


// Timing class to wrap Java's System timer calls
class Timing{
    long start;
    
    // Sets the starting time
    Timing(){ reset(); }
    // Current time in milliseconds
    static long current(){ return  System.currentTimeMillis(); }
    // Reset the starting time
    void reset(){ start = current(); }
    // Give the time diference
    long diff(){ return current()-start; }
    // Simple toString()
    public String toString(){ return " Timing("+diff()+")"; }
}
