/** 
 * Sorter class 
 * @author Bryan Chadwick
 * */

import java.util.ArrayList;
import java.util.Comparator;


// Abstract a little, so I can write my Test/Print functions without
//   relying one a specific sorting algorithm
public abstract class Sorter{
   String name;
   Sorter(String n){ name = n; }
   abstract void sort(ArrayList<Integer> list, Comparator<Integer> comp);
}

//  Wraps Algorithm's insertionSort
class Insert extends Sorter{
   Insert(){ super("insert"); }
   void sort(ArrayList<Integer> list, Comparator<Integer> comp){ 
       Algorithms.insertionSort(list, comp);
   }
}

// Wraps Algorithm's quickSort
class Quick extends Sorter{
   Quick(){ super("quick"); }
   void sort(ArrayList<Integer> list, Comparator<Integer> comp){
       Algorithms.quickSort(list, comp);
   }
}
