/** 
 * Examples class 
 * @author Bryan Chadwick
 * */

import java.util.ArrayList;
import java.util.Comparator;


// Tests and Examples
public class Examples {
    // Generate a random list of integers of given size using max for a bound
    //   on the actual numbers generated
    static ArrayList<Integer> fillData(int size, int max){
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        for(int i = 0; i < size; i++)
            list.add(randomInt(max));
        return list;
    }

    // Return a nice random Integer between: [0, top)
    static Integer randomInt(int top){ return new Integer(Algorithms.randInt(0, top));}
    
    // Wrapper for System.out.println
    public static void println(String s){ print(s+'\n'); }
    // Wrapper for System.out.print
    public static void print(String s){ System.out.print(s); }

    // Normal main(...) for running Tests
    public static void main(String[] args) {
        // Number of times to run our timings
        //   'final' means we can't change (mutate) these ints
        final int loops = 0, 
                  runs = 100;

        // Current size of the lists being sorted
        int size = 64;

        Comparator<Integer> comp = null;
        
        // Easy visual sort tests
        simpleTest(new Insert(), comp);
        simpleTest(new Quick(), comp);

        // Print out the Timings for each of the sorts in a kind of table
        println("\nTimings:");
        println(" N\tInsert\tQuick");
        for(int j = 0; j < loops; j++){
            print(" "+size+"\t  ");
            print(timeSort(new Insert(), runs, size, comp)+"\t  ");
            println(""+timeSort(new Quick(), runs, size, comp));
            size *= 2;
        }
        
    }

    // Abstract Test methods incase I add more Sorters
    // Visual check of the sorter methods
    static void simpleTest(Sorter sorter, Comparator<Integer> comp){        
        ArrayList<Integer> list = fillData(10, 40);
        println("          Start\t: "+list);
        sorter.sort(list, comp);
        println("   Sort("+sorter.name+")\t: "+list);
    }

    // Timing of a number of runs of a sorter method
    static long timeSort(Sorter sorter, int runs, int size, Comparator<Integer> comp){
        ArrayList<Integer> list;
        long total = 0;
        Timing time;
        
        for(int i = 0; i < runs; i++){
            list = fillData(size, 1000);
            time = new Timing();
            sorter.sort(list, comp);
            total += time.diff();
        }
        return total;
    }
}
