/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextTools {
    private TextTools() {
    }

    public static String readTextFile(String string) {
        if (string == null) {
            throw new RuntimeException("Null path in readTextFile");
        }
        int n = 8092;
        StringBuffer stringBuffer = new StringBuffer(n);
        char[] cArray = new char[n];
        try {
            int n2;
            FileReader fileReader = new FileReader(string);
            while ((n2 = fileReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n2);
            }
            fileReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return stringBuffer.toString();
    }

    public static void writeTextFile(String string, String string2) {
        if (string == null) {
            throw new RuntimeException("Null path in writeTextFile");
        }
        if (string2 == null) {
            throw new RuntimeException("Null data in writeTextFile");
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public static void copyTextFile(String string, String string2) {
        TextTools.writeTextFile(string2, TextTools.readTextFile(string));
    }

    public static String[] readNonEmptyLines(String string) {
        return TextTools.extractNonEmptyLines(TextTools.readTextFile(string));
    }

    public static String[] extractNonEmptyLines(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            vector.add(string2);
        }
        return vector.toArray(new String[0]);
    }

    public static String[] readFileNames(String string, String string2) {
        try {
            return TextTools.readNonEmptyLines(TextTools.makePath(string, string2));
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static String makePath(String string, String string2) {
        if (string == null) {
            throw new RuntimeException("Null directory in makePath");
        }
        if (string2 == null) {
            throw new RuntimeException("Null filename in makePath");
        }
        String string3 = "";
        int n = string.length();
        if (n > 0 && string.charAt(n - 1) != File.separatorChar) {
            string3 = File.separator;
        }
        return String.valueOf(string) + string3 + string2;
    }
}

