/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.awt.geom.Point2D;

public class FloatArray {
    private FloatArray() {
    }

    public static float[] deepclone(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        return (float[])fArray.clone();
    }

    public static float[][] deepclone(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][] fArray2 = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = FloatArray.deepclone(fArray[n2]);
            ++n2;
        }
        return fArray2;
    }

    public static float[] deepmerge(float[] fArray, float[] fArray2) {
        if (fArray == null && fArray2 == null) {
            return null;
        }
        if (fArray == null) {
            return FloatArray.deepclone(fArray2);
        }
        if (fArray2 == null) {
            return FloatArray.deepclone(fArray);
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        int n3 = n + n2;
        float[] fArray3 = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            fArray3[n4] = n4 < n ? fArray[n4] : fArray2[n4 - n];
            ++n4;
        }
        return fArray3;
    }

    public static float[][] deepmerge(float[][] fArray, float[][] fArray2) {
        if (fArray == null && fArray2 == null) {
            return null;
        }
        if (fArray == null) {
            return FloatArray.deepclone(fArray2);
        }
        if (fArray2 == null) {
            return FloatArray.deepclone(fArray);
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        int n3 = Math.max(n, n2);
        float[][] fArray3 = new float[n3][];
        int n4 = 0;
        while (n4 < n3) {
            float[] fArray4 = n4 < n ? fArray[n4] : null;
            float[] fArray5 = n4 < n2 ? fArray2[n4] : null;
            fArray3[n4] = FloatArray.deepmerge(fArray4, fArray5);
            ++n4;
        }
        return fArray3;
    }

    public static boolean checkArray(float[][] fArray, int n) {
        if (fArray == null) {
            return false;
        }
        int n2 = fArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (fArray[n3] == null || fArray[n3].length != n) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean checkArrayPair(float[][] fArray, float[][] fArray2, int n) {
        return fArray != null && fArray2 != null && fArray.length == fArray2.length && FloatArray.checkArray(fArray, n) && FloatArray.checkArray(fArray2, n);
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null && fArray2 != null) {
            return false;
        }
        if (fArray != null && fArray2 == null) {
            return false;
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (fArray[n3] != fArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(float[][] fArray, float[][] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null && fArray2 != null) {
            return false;
        }
        if (fArray != null && fArray2 == null) {
            return false;
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!FloatArray.equals(fArray[n3], fArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static float[] fromPoint2D(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        float f = (float)point2D.getX();
        float f2 = (float)point2D.getY();
        return new float[]{f, f2};
    }

    public static float[][] fromPoint2D(Point2D[] point2DArray) {
        if (point2DArray == null) {
            return null;
        }
        int n = point2DArray.length;
        float[][] fArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = FloatArray.fromPoint2D(point2DArray[n2]);
            ++n2;
        }
        return fArray;
    }

    public static Point2D toPoint2D(float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return null;
        }
        return new Point2D.Double(fArray[0], fArray[1]);
    }

    public static Point2D[] toPoint2D(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        Point2D[] point2DArray = new Point2D[n];
        int n2 = 0;
        while (n2 < n) {
            point2DArray[n2] = FloatArray.toPoint2D(fArray[n2]);
            ++n2;
        }
        return point2DArray;
    }
}

