/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.Strings;
import edu.neu.ccs.util.FileExistsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class FileUtilities {
    private FileUtilities() {
    }

    public static void copyFile(String string, String string2, boolean bl) throws FileExistsException, IOException {
        FileUtilities.copyFile(new File(string), new File(string2), bl);
    }

    public static void copyFile(File file, File file2, boolean bl) throws FileExistsException, IOException {
        if (file2.exists() && !bl) {
            throw new FileExistsException(file2);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[4096];
        int n = fileInputStream.read(byArray, 0, byArray.length);
        while (n > -1) {
            fileOutputStream.write(byArray, 0, n);
            n = fileInputStream.read(byArray, 0, byArray.length);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void createDirectory(File file) throws FileExistsException, IOException {
        if (file.exists()) {
            throw new FileExistsException(file);
        }
        if (!file.mkdirs()) {
            throw new IOException();
        }
    }

    public static void createDirectory(String string) throws FileExistsException, IOException {
        FileUtilities.createDirectory(new File(string));
    }

    public static void deleteFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (!file.delete()) {
            throw new IOException();
        }
    }

    public static void deleteFile(String string) throws FileNotFoundException, IOException {
        FileUtilities.deleteFile(new File(string));
    }

    public static String[] readDirectory(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (!file.isDirectory() || !file.canRead()) {
            throw new IOException();
        }
        return file.list();
    }

    public static String[] readDirectory(String string) throws FileNotFoundException, IOException {
        return FileUtilities.readDirectory(new File(string));
    }

    public static String[] filterFileList(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        Vector<String> vector = new Vector<String>();
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                if (FileUtilities.matchesExtension(stringArray[n4], stringArray2[n3])) {
                    vector.add(stringArray[n4]);
                }
                ++n4;
            }
            ++n3;
        }
        return vector.toArray(new String[0]);
    }

    public static String[] filterFileList(String[] stringArray, String string) {
        if (string == null) {
            return stringArray;
        }
        return FileUtilities.filterFileList(stringArray, Strings.splitCommaList(string));
    }

    public static boolean matchesExtension(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string.length();
        int n2 = string2.length();
        if (n2 == 0) {
            return false;
        }
        int n3 = n - n2;
        return string.regionMatches(true, n3, string2, 0, n2);
    }

    public static StringBuffer getFileContents(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (!file.isFile() || !file.canRead()) {
            throw new IOException();
        }
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = fileInputStream.read(byArray);
        while (n > 0) {
            stringBuffer.append(new String(byArray, 0, n));
            n = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        return stringBuffer;
    }

    public static String readFile(File file) throws FileNotFoundException, IOException {
        return FileUtilities.getFileContents(file).toString();
    }

    public static String readFile(String string) throws FileNotFoundException, IOException {
        return FileUtilities.getFileContents(new File(string)).toString();
    }

    public static void renameFile(File file, File file2) throws FileNotFoundException, FileExistsException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (file2.exists()) {
            throw new FileExistsException(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    public static void renameFile(String string, String string2) throws FileNotFoundException, FileExistsException, IOException {
        FileUtilities.renameFile(new File(string), new File(string2));
    }

    public static void writeFile(File file, String string, boolean bl) throws FileExistsException, IOException {
        if (file.exists() && !bl) {
            throw new FileExistsException(file);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string.getBytes());
        fileOutputStream.close();
    }

    public static void writeFile(String string, String string2, boolean bl) throws FileExistsException, IOException {
        FileUtilities.writeFile(new File(string), string2, bl);
    }
}

