/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.Strings;
import java.io.File;
import java.io.FileFilter;

public class FileExtensionFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private String commaList = "";
    private String[] arrayList = new String[0];
    private int N = 0;
    private boolean ignoreCase = true;
    private String dialogDescription = "All Files";

    public FileExtensionFilter() {
    }

    public FileExtensionFilter(String commaList) {
        this.setExtensions(commaList);
    }

    public FileExtensionFilter(String[] arrayList) {
        this.setExtensions(arrayList);
    }

    public FileExtensionFilter(String commaList, boolean ignoreCase) {
        this.setExtensions(commaList);
        this.setIgnoreCase(ignoreCase);
    }

    public FileExtensionFilter(String[] arrayList, boolean ignoreCase) {
        this.setExtensions(arrayList);
        this.setIgnoreCase(ignoreCase);
    }

    public final void setExtensions(String commaList) {
        if (commaList == null) {
            commaList = "";
        }
        this.commaList = commaList;
        this.arrayList = Strings.splitCommaList(commaList);
        this.N = this.arrayList.length;
        this.dialogDescription = this.makeStandardDescription();
    }

    public final void setExtensions(String[] arrayList) {
        if (arrayList == null) {
            arrayList = new String[]{};
        }
        this.commaList = Strings.makeCommaList(arrayList);
        this.arrayList = arrayList;
        this.N = this.arrayList.length;
        this.dialogDescription = this.makeStandardDescription();
    }

    public final String getExtensionsAsCommaList() {
        return this.commaList;
    }

    public final void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public final boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public final boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (this.N == 0) {
            return true;
        }
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        int S = name.length();
        int i = 0;
        while (i < this.N) {
            String ext = this.arrayList[i];
            int E = ext.length();
            if (S > E) {
                boolean test;
                boolean bl = test = name.charAt(S - E - 1) == '.' && name.regionMatches(true, S - E, ext, 0, E);
                if (test) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public String getDescription() {
        return this.dialogDescription;
    }

    protected String makeStandardDescription() {
        if (this.N == 0) {
            return "All Files";
        }
        if (this.N == 1) {
            return "*." + this.commaList;
        }
        return "*.? for ? = " + this.commaList;
    }
}

