/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XLine2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.filter.MinimumBoundFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Halo;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PaintableTools;
import edu.neu.ccs.gui.ShapePaintable;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class SimpleArrayPanel
extends TablePanel {
    public static final int MINIMUM_LENGTH = 1;
    public static final int MINIMUM_VISIBLE = 2;
    public static final int MINIMUM_GAP = 4;
    public static final Paintable insertRowPaintable = SimpleArrayPanel.makeInsertRowPaintable();
    public static final Paintable deleteRowPaintable = SimpleArrayPanel.makeDeleteRowPaintable();
    protected Class viewType = null;
    protected Class viewDataType = null;
    protected int arrayLength = 0;
    protected int lengthOffset = 0;
    protected int initialIndex = 0;
    protected int visibleViewCount = 2;
    protected int gap = 4;
    protected boolean autoHalo = false;
    protected int viewWidth = 0;
    protected int viewHeight = 0;
    protected int labelWidth = TextFieldView.getSampleWidth("0000");
    protected TablePanel innerPanel = null;
    protected JPTScrollPane scrollPane = null;
    protected TablePanel controls = null;
    protected TextFieldView lengthTFV = new TextFieldView(this.labelWidth);
    protected SimpleAction incrementLength = new 1("+");
    protected SimpleAction decrementLength = new 2("-");
    protected SimpleAction setLengthFromGUI = new 3("Set Length");
    protected Vector viewList = new Vector();
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$edu$neu$ccs$gui$TypedView;

    public SimpleArrayPanel(Class viewType) {
        this(viewType, 0, 2, 4, false);
    }

    public SimpleArrayPanel(Class viewType, int initialIndex) {
        this(viewType, initialIndex, 2, 4, false);
    }

    public SimpleArrayPanel(Class viewType, int initialIndex, int visibleViewCount) {
        this(viewType, initialIndex, visibleViewCount, 4, false);
    }

    public SimpleArrayPanel(Class viewType, int initialIndex, int visibleViewCount, int gap) {
        this(viewType, initialIndex, visibleViewCount, gap, false);
    }

    public SimpleArrayPanel(Class viewType, int initialIndex, int visibleViewCount, int gap, boolean autoHalo) {
        this.setViewType(viewType);
        this.setInitialIndex(initialIndex);
        this.setVisibleViewCount(visibleViewCount);
        this.setTableGap(gap);
        this.setAutoHalo(autoHalo);
        this.buildArrayPanel();
    }

    public final Class getViewType() {
        return this.viewType;
    }

    public final Class getViewDataType() {
        return this.viewDataType;
    }

    public final TypedView getTypedView(int i) {
        if (i < 0 || i >= this.arrayLength) {
            return null;
        }
        return (TypedView)this.viewList.get(i);
    }

    public final void setViewState(int i, String data) {
        TypedView typedview = this.getTypedView(i);
        if (typedview != null && data != null) {
            typedview.setViewState(data);
        }
    }

    public final String getViewState(int i) {
        TypedView typedview = this.getTypedView(i);
        if (typedview == null) {
            return null;
        }
        return typedview.getViewState();
    }

    public final void setDefaultViewState(int i, String data) {
        TypedView typedview = this.getTypedView(i);
        if (typedview != null && data != null) {
            typedview.setDefaultViewState(data);
        }
    }

    public final String getDefaultViewState(int i) {
        TypedView typedview = this.getTypedView(i);
        if (typedview == null) {
            return null;
        }
        return typedview.getDefaultViewState();
    }

    public final void reset(int i) {
        TypedView typedview = this.getTypedView(i);
        if (typedview == null) {
            return;
        }
        typedview.reset();
    }

    public final Stringable demandObject(int i) {
        TypedView typedview = this.getTypedView(i);
        if (typedview == null) {
            return null;
        }
        return typedview.demandObject();
    }

    public final Stringable requestObject(int i) throws CancelledException {
        TypedView typedview = this.getTypedView(i);
        if (typedview == null) {
            return null;
        }
        return typedview.requestObject();
    }

    public final void setInputProperties(int i, InputProperties properties) {
        TypedView typedview = this.getTypedView(i);
        if (typedview == null) {
            return;
        }
        typedview.setInputProperties(properties);
    }

    public final InputProperties getInputProperties(int i) {
        TypedView typedview = this.getTypedView(i);
        if (typedview == null) {
            return null;
        }
        return typedview.getInputProperties();
    }

    public final Object getViews() {
        Object array = Array.newInstance(this.viewType, this.arrayLength);
        int i = 0;
        while (i < this.arrayLength) {
            Array.set(array, i, this.getTypedView(i));
            ++i;
        }
        return array;
    }

    public final Object demandObjects() {
        Object array = Array.newInstance(this.viewDataType, this.arrayLength);
        int i = 0;
        while (i < this.arrayLength) {
            Array.set(array, i, this.demandObject(i));
            ++i;
        }
        return array;
    }

    public final Object requestObjects() throws CancelledException {
        Object array = Array.newInstance(this.viewDataType, this.arrayLength);
        int i = 0;
        while (i < this.arrayLength) {
            Array.set(array, i, this.requestObject(i));
            ++i;
        }
        return array;
    }

    public final TypedView[] getTypedViewArray() {
        TypedView[] typedviews = new TypedView[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            typedviews[i] = this.getTypedView(i);
            ++i;
        }
        return typedviews;
    }

    public final Stringable[] demandStringableArray() {
        Stringable[] stringables = new Stringable[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            stringables[i] = this.demandObject(i);
            ++i;
        }
        return stringables;
    }

    public final Stringable[] requestStringableArray() throws CancelledException {
        Stringable[] stringables = new Stringable[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            stringables[i] = this.requestObject(i);
            ++i;
        }
        return stringables;
    }

    public final void setViewStates(String[] data) {
        if (data == null) {
            return;
        }
        int min = Math.min(this.arrayLength, data.length);
        int i = 0;
        while (i < min) {
            if (data[i] != null) {
                this.setViewState(i, data[i]);
            }
            ++i;
        }
    }

    public final String[] getViewStates() {
        String[] data = new String[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            data[i] = this.getViewState(i);
            ++i;
        }
        return data;
    }

    public final void setDefaultViewStates(String[] data) {
        if (data == null) {
            return;
        }
        int min = Math.min(this.arrayLength, data.length);
        int i = 0;
        while (i < min) {
            if (data[i] != null) {
                this.setDefaultViewState(i, data[i]);
            }
            ++i;
        }
    }

    public final String[] getDefaultViewStates() {
        String[] data = new String[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            data[i] = this.getDefaultViewState(i);
            ++i;
        }
        return data;
    }

    public final void setCommonInputProperties(InputProperties properties) {
        int i = 0;
        while (i < this.arrayLength) {
            this.setInputProperties(i, properties);
            ++i;
        }
    }

    public final void setInputPropertiesByView(InputProperties[] properties) {
        if (properties == null) {
            return;
        }
        int min = Math.min(this.arrayLength, properties.length);
        int i = 0;
        while (i < min) {
            this.setInputProperties(i, properties[i]);
            ++i;
        }
    }

    public final InputProperties[] getInputPropertiesByView() {
        InputProperties[] properties = new InputProperties[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            properties[i] = this.getInputProperties(i);
            ++i;
        }
        return properties;
    }

    public final void setViewState(String data) {
        this.setViewStates(Strings.decode(data));
    }

    public final String getViewState() {
        return CodecUtilities.encode(this.getViewStates());
    }

    public final void setDefaultViewState(String data) {
        this.setDefaultViewStates(Strings.decode(data));
    }

    public final String getDefaultViewState() {
        return CodecUtilities.encode(this.getDefaultViewStates());
    }

    public final void reset() {
        int i = 0;
        while (i < this.arrayLength) {
            this.reset(i);
            ++i;
        }
    }

    public final void setInputProperties(InputProperties properties) {
    }

    public final InputProperties getInputProperties() {
        return null;
    }

    public final int getLength() {
        return this.arrayLength;
    }

    public final int getUserLength() {
        return this.arrayLength + this.lengthOffset;
    }

    public final int getLengthOffset() {
        return this.lengthOffset;
    }

    public final String getLengthButtonName() {
        return (String)this.setLengthFromGUI.getValue("Name");
    }

    public final void setLength(int length) {
        if (length < 1) {
            length = 1;
        }
        if (length == this.arrayLength) {
            return;
        }
        if (length > this.arrayLength) {
            int i = this.arrayLength;
            while (i < length) {
                String label = this.createLabelForRow(i);
                this.innerPanel.addObject((Object)label, i, 0);
                TypedView view = this.createViewForRow(i);
                this.viewList.add(view);
                Displayable object = view;
                if (this.autoHalo) {
                    object = new Halo(object);
                }
                this.innerPanel.addObject((Object)object, i, 1);
                JButton insertButton = this.getInsertRowButton(i);
                JButton deleteButton = this.getDeleteRowButton(i);
                this.innerPanel.addObject((Object)insertButton, i, 2);
                this.innerPanel.addObject((Object)deleteButton, i, 3);
                ++i;
            }
        } else {
            int i = this.arrayLength - 1;
            while (i >= length) {
                this.viewList.remove(i);
                int k = 4 * i;
                this.innerPanel.remove(k + 3);
                this.innerPanel.remove(k + 2);
                this.innerPanel.remove(k + 1);
                this.innerPanel.remove(k);
                --i;
            }
        }
        this.arrayLength = length;
        this.lengthTFV.setViewState(String.valueOf(this.getUserLength()));
        this.repaint();
    }

    public final void setUserLength(int userLength) {
        this.setLength(userLength - this.lengthOffset);
    }

    public final void setLengthOffset(int offset) {
        this.lengthOffset = offset;
        this.lengthTFV.setViewState(String.valueOf(this.getUserLength()));
    }

    public final void setLengthButtonName(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        this.setLengthFromGUI.putValue("Name", name);
    }

    public final void incrementLength() {
        this.setLength(this.arrayLength + 1);
    }

    public final void decrementLength() {
        this.setLength(this.arrayLength - 1);
    }

    public String createLabelForRow(int i) {
        return String.valueOf(i + this.initialIndex);
    }

    protected TypedView createViewForRow(int i) {
        TypedView typedview = null;
        try {
            typedview = (TypedView)this.viewType.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to construct view in SimpleArrayPanel");
        }
        return typedview;
    }

    protected final void setViewType(Class viewType) {
        if (viewType == null) {
            throw new NullPointerException("View type in SimpleArrayPanel must be non-null");
        }
        if (!(class$javax$swing$JComponent != null ? class$javax$swing$JComponent : (class$javax$swing$JComponent = SimpleArrayPanel.class$("javax.swing.JComponent"))).isAssignableFrom(viewType)) {
            throw new IllegalArgumentException("View type in SimpleArrayPanel must extend JComponent");
        }
        if (!(class$edu$neu$ccs$gui$TypedView != null ? class$edu$neu$ccs$gui$TypedView : (class$edu$neu$ccs$gui$TypedView = SimpleArrayPanel.class$("edu.neu.ccs.gui.TypedView"))).isAssignableFrom(viewType)) {
            throw new IllegalArgumentException("View type in SimpleArrayPanel must implement TypedView");
        }
        this.viewType = viewType;
        TypedView typedview = this.createViewForRow(0);
        JComponent component = (JComponent)((Object)typedview);
        this.viewDataType = typedview.getDataType();
        Dimension dimension = component.getPreferredSize();
        this.viewWidth = dimension.width;
        this.viewHeight = dimension.height;
    }

    protected final void setInitialIndex(int initialIndex) {
        this.initialIndex = initialIndex;
    }

    protected final void setVisibleViewCount(int visibleViewCount) {
        if (visibleViewCount < 2) {
            visibleViewCount = 2;
        }
        this.visibleViewCount = visibleViewCount;
    }

    protected final void setTableGap(int gap) {
        if (gap < 4) {
            gap = 4;
        }
        this.gap = gap;
        this.setHorizontalGap(gap);
        this.setVerticalGap(gap);
    }

    protected final void setAutoHalo(boolean autoHalo) {
        this.autoHalo = autoHalo;
    }

    protected final void buildArrayPanel() {
        this.buildInnerPanel();
        this.buildScrollPane();
        this.buildControls();
        this.setTableAlignment(0);
        this.addObject((Object)this.scrollPane, 0, 0);
        this.addObject((Object)this.controls, 1, 0);
        this.lengthTFV.addActionListener(this.setLengthFromGUI);
    }

    protected final void buildInnerPanel() {
        this.innerPanel = new TablePanel(16, 4, this.gap, this.gap, 0);
        this.innerPanel.setMinimumColumnWidth(0, this.labelWidth);
        this.setLength(1);
    }

    protected final void buildScrollPane() {
        int vsb = 22;
        int hsb = 32;
        Border border = BorderFactory.createEmptyBorder(this.gap, this.gap, this.gap, this.gap);
        this.innerPanel.setBorder(border);
        this.scrollPane = new JPTScrollPane(this.innerPanel, vsb, hsb);
        int extra = this.autoHalo ? 4 : 0;
        JButton sample = this.getInsertRowButton(0);
        Dimension dimension = sample.getPreferredSize();
        int w = (int)dimension.getWidth();
        int h = (int)dimension.getHeight();
        h = Math.max(this.viewHeight + extra, h);
        int width = this.labelWidth + this.viewWidth + extra + 2 * w + 5 * this.gap;
        int height = this.visibleViewCount * (h + this.gap) + this.gap;
        this.scrollPane.setViewportPreferredSize(width, height);
    }

    protected final void buildControls() {
        Object[] vArray = new Object[]{this.setLengthFromGUI, this.lengthTFV};
        TablePanel nestedControls = new TablePanel(vArray, 1, this.gap, this.gap, 0);
        JButton increment = PaintableTools.makeButton(insertRowPaintable, this.incrementLength);
        JButton decrement = PaintableTools.makeButton(deleteRowPaintable, this.decrementLength);
        Object[] hArray = new Object[]{increment, nestedControls, decrement};
        this.controls = new TablePanel(hArray, 0, this.gap, this.gap, 0);
    }

    public final void insertRowAtIndex(int index) {
        int L = this.getLength();
        if (index < 0 || index >= L) {
            return;
        }
        this.incrementLength();
        int i = L;
        while (i > index) {
            TypedView above = this.getTypedView(i);
            TypedView below = this.getTypedView(i - 1);
            above.setViewState(below.getViewState());
            --i;
        }
        TypedView start = this.getTypedView(index);
        start.setViewState(start.getDefaultViewState());
    }

    public final void deleteRowAtIndex(int index) {
        int L = this.getLength();
        if (L <= 1) {
            return;
        }
        if (index < 0 || index >= L) {
            return;
        }
        int i = index + 1;
        while (i < L) {
            TypedView above = this.getTypedView(i);
            TypedView below = this.getTypedView(i - 1);
            below.setViewState(above.getViewState());
            ++i;
        }
        this.decrementLength();
    }

    public Action getInsertRowAction(int index) {
        return new 4(index, this);
    }

    public Action getDeleteRowAction(int index) {
        return new 5(index, this);
    }

    public JButton getInsertRowButton(int index) {
        return PaintableTools.makeButton(insertRowPaintable, this.getInsertRowAction(index));
    }

    public JButton getDeleteRowButton(int index) {
        return PaintableTools.makeButton(deleteRowPaintable, this.getDeleteRowAction(index));
    }

    protected final void setLengthFromGUI() {
        int MINIMUM = 1 + this.lengthOffset;
        MinimumBoundFilter.Long filter = new MinimumBoundFilter.Long(MINIMUM);
        try {
            this.setUserLength(this.lengthTFV.requestInt(filter));
        }
        catch (CancelledException cancelledException) {}
    }

    public static Paintable makeInsertRowPaintable() {
        XRect r = new XRect(0.0, 0.0, 16.0, 16.0);
        XLine2D v = new XLine2D(8.0, 4.0, 8.0, 12.0);
        XLine2D h = new XLine2D(4.0, 8.0, 12.0, 8.0);
        BasicStroke stroke = new BasicStroke(2.0f);
        ShapePaintable p1 = new ShapePaintable(v, PaintMode.DRAW, null, (Paint)Colors.black, (Stroke)stroke);
        ShapePaintable p2 = new ShapePaintable(h, PaintMode.DRAW, null, (Paint)Colors.black, (Stroke)stroke);
        ShapePaintable p3 = new ShapePaintable(r, PaintMode.FILL, (Paint)Colors.lightskyblue);
        PaintableSequence icon = new PaintableSequence(new Object[]{p1, p2, p3});
        return icon;
    }

    public static Paintable makeDeleteRowPaintable() {
        XRect r = new XRect(0.0, 0.0, 16.0, 16.0);
        XLine2D a = new XLine2D(4.0, 4.0, 12.0, 12.0);
        XLine2D b = new XLine2D(12.0, 4.0, 4.0, 12.0);
        BasicStroke stroke = new BasicStroke(2.0f);
        ShapePaintable p1 = new ShapePaintable(a, PaintMode.DRAW, null, (Paint)Colors.black, (Stroke)stroke);
        ShapePaintable p2 = new ShapePaintable(b, PaintMode.DRAW, null, (Paint)Colors.black, (Stroke)stroke);
        ShapePaintable p3 = new ShapePaintable(r, PaintMode.FILL, (Paint)Colors.red);
        PaintableSequence icon = new PaintableSequence(new Object[]{p1, p2, p3});
        return icon;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends SimpleAction {
        public void perform() {
            SimpleArrayPanel.this.incrementLength();
        }

        /* synthetic */ 1(String $0) {
            super($0);
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            SimpleArrayPanel.this.decrementLength();
        }

        /* synthetic */ 2(String $0) {
            super($0);
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            SimpleArrayPanel.this.setLengthFromGUI();
        }

        /* synthetic */ 3(String $0) {
            super($0);
        }
    }

    private static final class 4
    extends SimpleAction {
        private final /* synthetic */ SimpleArrayPanel this$0;
        private final /* synthetic */ int val$index;

        public void perform() {
            this.this$0.insertRowAtIndex(this.val$index);
        }

        /* synthetic */ 4(int val$index, SimpleArrayPanel this$0) {
            this.val$index = val$index;
            this.this$0 = this$0;
        }
    }

    private static final class 5
    extends SimpleAction {
        private final /* synthetic */ SimpleArrayPanel this$0;
        private final /* synthetic */ int val$index;

        public void perform() {
            this.this$0.deleteRowAtIndex(this.val$index);
        }

        /* synthetic */ 5(int val$index, SimpleArrayPanel this$0) {
            this.val$index = val$index;
            this.this$0 = this$0;
        }
    }
}

