/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseShape;
import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Path {
    public static final int SIZE = 6;
    public static final int HALF = 3;
    public static final Rectangle2D.Double DOT = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    public static final int THICK = 2;
    public static final BasicStroke STROKE = new BasicStroke(2.0f);
    public static final Strategy POLYGON = new 1();
    public static final Strategy POLYGON_DOTS = new 2();
    public static final Strategy BEZIER_CUBIC = new 3();
    public static final Strategy BEZIER_FRAME = new 4();
    public static final Strategy BEZIER_TANGENT_SEGMENTS = new 5();

    private Path() {
    }

    public static GeneralPath append(GeneralPath generalPath, Shape[] shapeArray, boolean[] blArray) {
        if (generalPath == null) {
            generalPath = new GeneralPath();
        }
        if (shapeArray == null) {
            return generalPath;
        }
        int n = shapeArray.length;
        if (blArray == null) {
            blArray = new boolean[n + 1];
        } else if (blArray.length != n + 1) {
            return generalPath;
        }
        int n2 = 0;
        while (n2 < n) {
            if (shapeArray[n2] != null) {
                generalPath.append(shapeArray[n2], blArray[n2]);
            }
            ++n2;
        }
        if (blArray[n]) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public static GeneralPath append(GeneralPath generalPath, Shape[] shapeArray, boolean bl) {
        if (shapeArray == null) {
            return generalPath;
        }
        int n = shapeArray.length;
        boolean[] blArray = new boolean[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            blArray[n2] = bl;
            ++n2;
        }
        return Path.append(generalPath, shapeArray, blArray);
    }

    public static void showShapeStructure(Graphics graphics, Shape shape, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, int n) {
        if (graphics == null || shape == null) {
            return;
        }
        PathList pathList = new PathList(shape);
        PaintableSequence paintableSequence = pathList.makeStructurePaintable(color, color2, color3, color4, color5, color6, n);
        paintableSequence.paint(graphics);
    }

    public static void showShapeStructure(Graphics graphics, Shape shape, Color color, Color color2, int n) {
        if (graphics == null || shape == null) {
            return;
        }
        PathList pathList = new PathList(shape);
        PaintableSequence paintableSequence = pathList.makeStructurePaintable(color, color2, n);
        paintableSequence.paint(graphics);
    }

    public static void showShapeStructure(Graphics graphics, Shape shape, int n) {
        if (graphics == null || shape == null) {
            return;
        }
        PathList pathList = new PathList(shape);
        PaintableSequence paintableSequence = pathList.makeStructurePaintable(n);
        paintableSequence.paint(graphics);
    }

    public static void showShapeStructure(Graphics graphics, Shape shape) {
        if (graphics == null || shape == null) {
            return;
        }
        PathList pathList = new PathList(shape);
        PaintableSequence paintableSequence = pathList.makeStructurePaintable();
        paintableSequence.paint(graphics);
    }

    public static String shapeToString(Shape shape) {
        if (shape == null) {
            return "Null shape\n";
        }
        return new PathList(shape).toString();
    }

    public static interface Strategy {
        public GeneralPath makePath(float[][] var1, float[][] var2, ClosureMode var3, WindingRule var4);
    }

    private final class 1
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            int n;
            if (closureMode == null) {
                closureMode = ClosureMode.CLOSED;
            }
            if (windingRule == null) {
                windingRule = WindingRule.WIND_NON_ZERO;
            }
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArray(fArray, 2) && (n = fArray.length) > 0) {
                generalPath.moveTo(fArray[0][0], fArray[0][1]);
                int n2 = 1;
                while (n2 < n) {
                    generalPath.lineTo(fArray[n2][0], fArray[n2][1]);
                    ++n2;
                }
                if (closureMode == ClosureMode.CLOSED) {
                    generalPath.closePath();
                }
            }
            return generalPath;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            if (windingRule == null) {
                windingRule = WindingRule.WIND_NON_ZERO;
            }
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArray(fArray, 2)) {
                int n = fArray.length;
                int n2 = 0;
                while (n2 < n) {
                    generalPath.moveTo(fArray[n2][0], fArray[n2][1]);
                    generalPath.lineTo(fArray[n2][0], fArray[n2][1]);
                    ++n2;
                }
            }
            return generalPath;
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            int n;
            if (closureMode == null) {
                closureMode = ClosureMode.CLOSED;
            }
            if (windingRule == null) {
                windingRule = WindingRule.WIND_NON_ZERO;
            }
            if (fArray2 == null) {
                return POLYGON.makePath(fArray, null, closureMode, windingRule);
            }
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArrayPair(fArray, fArray2, 2) && (n = fArray.length) > 0) {
                generalPath.moveTo(fArray[0][0], fArray[0][1]);
                int n2 = closureMode.limit(n);
                int n3 = 1;
                while (n3 <= n2) {
                    int n4 = n3 - 1;
                    int n5 = n3 < n ? n3 : 0;
                    float f = fArray[n4][0] + fArray2[n4][0];
                    float f2 = fArray[n4][1] + fArray2[n4][1];
                    float f3 = fArray[n5][0] - fArray2[n5][0];
                    float f4 = fArray[n5][1] - fArray2[n5][1];
                    float f5 = fArray[n5][0];
                    float f6 = fArray[n5][1];
                    generalPath.curveTo(f, f2, f3, f4, f5, f6);
                    ++n3;
                }
                if (closureMode == ClosureMode.CLOSED) {
                    generalPath.closePath();
                }
            }
            return generalPath;
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            if (closureMode == null) {
                closureMode = ClosureMode.CLOSED;
            }
            if (windingRule == null) {
                windingRule = WindingRule.WIND_NON_ZERO;
            }
            if (fArray2 == null) {
                return POLYGON.makePath(fArray, null, closureMode, windingRule);
            }
            if (closureMode == ClosureMode.CLOSED) {
                return POLYGON.makePath(BaseShape.closedBezierFramePoints(fArray, fArray2), null, closureMode, windingRule);
            }
            return POLYGON.makePath(BaseShape.openBezierFramePoints(fArray, fArray2), null, closureMode, windingRule);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            int n;
            if (windingRule == null) {
                windingRule = WindingRule.WIND_NON_ZERO;
            }
            if (fArray2 == null) {
                return POLYGON_DOTS.makePath(fArray, null, closureMode, windingRule);
            }
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArrayPair(fArray, fArray2, 2) && (n = fArray.length) > 0) {
                float[][] fArray3 = BaseShape.bezierTangentSegmentPoints(fArray, fArray2);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = 2 * n2;
                    int n4 = n3 + 1;
                    generalPath.moveTo(fArray3[n3][0], fArray3[n3][1]);
                    generalPath.lineTo(fArray3[n4][0], fArray3[n4][1]);
                    ++n2;
                }
            }
            return generalPath;
        }

        /* synthetic */ 5() {
        }
    }
}

