/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.util.JPTConstants;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public class XRoundRect
extends RoundRectangle2D.Double
implements Serializable,
Stringable,
JPTConstants {
    private static String[] BLANK = new String[]{"", "", "", "", "", ""};
    private static String[] XYWHArcs = new String[]{"x", "y", "w", "h", "arcw", "arch"};
    private static String[] XYRSArcs = new String[]{"xc", "yc", "r", "s", "arcr", "arcs"};
    public static final String standardMessage = "\nXRoundRect Error: Data format must be\n[...;...;...;...;...;...] or\n[x=...;y=...;w=...;h=...;arcw=...;arch=...]\nwhere ... stands for\nthe corner coordinate data x,y,\nthe width-height data w,h,\nand the arc data arcw,arch or\n[xc=...;yc=...;r=...;s=...;arcr=...;arcs=...]\nwhere ... stands for\nthe center data xc,yc,\nthe radius data r,s,\nand the radius arc data arcr,arcs\n";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XRoundRect() {
    }

    public XRoundRect(double x, double y, double w, double h, double arcw, double arch) {
        this.setXYWHArcs(x, y, w, h, arcw, arch);
    }

    public XRoundRect(RoundRectangle2D roundrect) {
        this.setRoundRect(roundrect);
    }

    public XRoundRect(double r, double s, double arcr, double arcs) {
        this.setXYRSArcs(0.0, 0.0, r, s, arcr, arcs);
    }

    public String toString() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        double arcw = this.getArcWidth();
        double arch = this.getArcHeight();
        return "XRoundRect[x=" + x + ";y=" + y + ";w=" + w + ";h=" + h + ";arcw=" + arcw + ";arch=" + arch + "]";
    }

    public String toStringAsXYRSArcs() {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        double r = this.getWidth() / 2.0;
        double s = this.getHeight() / 2.0;
        double arcr = this.getArcWidth() / 2.0;
        double arcs = this.getArcHeight() / 2.0;
        return "XRoundRect[xc=" + xc + ";yc=" + yc + ";r=" + r + ";s=" + s + ";arcr=" + arcr + ";arcs=" + arcs + "]";
    }

    public String toStringData() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        double arcw = this.getArcWidth();
        double arch = this.getArcHeight();
        return "[" + x + ";" + y + ";" + w + ";" + h + ";" + arcw + ";" + arch + "]";
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (strings.length != 6) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (Arrays.equals(names, BLANK) || Arrays.equals(names, XYWHArcs)) {
            names = XYWHArcs;
        } else if (Arrays.equals(names, XYRSArcs)) {
            names = XYRSArcs;
        } else {
            throw new ParseException(standardMessage, -1);
        }
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XRoundRect", (String[])names);
        }
        if (names == XYWHArcs) {
            this.setXYWHArcs(result[0], result[1], result[2], result[3], result[4], result[5]);
            return;
        }
        if (names == XYRSArcs) {
            this.setXYRSArcs(result[0], result[1], result[2], result[3], result[4], result[5]);
            return;
        }
    }

    public void setXYWHArcs(double x, double y, double w, double h, double arcw, double arch) {
        if (w < 0.0) {
            w = Math.abs(w);
            x -= w;
        }
        if (h < 0.0) {
            h = Math.abs(h);
            y -= h;
        }
        arcw = Math.abs(arcw);
        arch = Math.abs(arch);
        arcw = arcw > w ? w : arcw;
        arch = arch > h ? h : arch;
        super.setRoundRect(x, y, w, h, arcw, arch);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setXYRSArcs(double xc, double yc, double r, double s, double arcr, double arcs) {
        r = Math.abs(r);
        s = Math.abs(s);
        arcr = Math.abs(arcr);
        arcs = Math.abs(arcs);
        arcr = arcr > r ? r : arcr;
        arcs = arcs > s ? s : arcs;
        this.setXYWHArcs(xc - r, yc - s, 2.0 * r, 2.0 * s, 2.0 * arcr, 2.0 * arcs);
    }

    public void setXYWH(double x, double y, double w, double h) {
        double arcw = this.getArcWidth();
        double arch = this.getArcHeight();
        this.setXYWHArcs(x, y, w, h, arcw, arch);
    }

    public void setXYRS(double xc, double yc, double r, double s) {
        r = Math.abs(r);
        s = Math.abs(s);
        this.setXYWH(xc - r, yc - s, 2.0 * r, 2.0 * s);
    }

    public void setX1Y1X2Y2(double x1, double y1, double x2, double y2) {
        this.setXYWH(x1, y1, x2 - x1, y2 - y1);
    }

    public void setRoundRect(double x, double y, double w, double h, double arcw, double arch) {
        this.setXYWHArcs(x, y, w, h, arcw, arch);
    }

    public void setRoundRect(RoundRectangle2D roundrect) {
        if (roundrect == null) {
            return;
        }
        double x = roundrect.getX();
        double y = roundrect.getY();
        double w = roundrect.getWidth();
        double h = roundrect.getHeight();
        double arcw = roundrect.getArcWidth();
        double arch = roundrect.getArcHeight();
        this.setXYWHArcs(x, y, w, h, arcw, arch);
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setXYWH(x, y, w, h);
    }

    public void setFrame(Rectangle2D rect) {
        if (rect == null) {
            return;
        }
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        this.setXYWH(x, y, w, h);
    }

    public void setFrame(Point2D point, Dimension2D dimension) {
        if (point == null || dimension == null) {
            return;
        }
        double x = point.getX();
        double y = point.getY();
        double w = dimension.getWidth();
        double h = dimension.getHeight();
        this.setXYWH(x, y, w, h);
    }

    public void setRect(double x, double y, double w, double h) {
        this.setXYWH(x, y, w, h);
    }

    public void setRect(Rectangle2D rect) {
        if (rect == null) {
            return;
        }
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        this.setXYWH(x, y, w, h);
    }

    public void move(double dx, double dy) {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        double arcw = this.getArcWidth();
        double arch = this.getArcHeight();
        this.setXYWHArcs(x + dx, y + dy, w, h, arcw, arch);
    }

    public void move(Point2D p) {
        if (p == null) {
            return;
        }
        this.move(p.getX(), p.getY());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

