/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.util.JPTConstants;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public class XPoint2D
extends Point2D.Double
implements Serializable,
Stringable,
JPTConstants {
    public static final String[] BLANK = new String[]{"", ""};
    public static final String[] XY = new String[]{"x", "y"};
    public static final String standardMessage = "\nXPoint2D Error: Data format must be\n[...;...] or\n[x=...;y=...]\nwhere ... stands for\nthe x,y coordinate data\n";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XPoint2D() {
    }

    public XPoint2D(double d, double d2) {
        this.setValue(d, d2);
    }

    public XPoint2D(Point2D point2D) {
        this.setValue(point2D);
    }

    public XPoint2D(double[] dArray) {
        this.setValue(dArray);
    }

    public XPoint2D(float[] fArray) {
        this.setValue(fArray);
    }

    public XPoint2D(String string) throws ParseException {
        this.fromStringData(string);
    }

    public String toString() {
        return "XPoint2D[x=" + this.x + ";y=" + this.y + "]";
    }

    public String toStringData() {
        return "[" + this.x + ";" + this.y + "]";
    }

    public void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] stringArray = Strings.decode(string);
        if (stringArray == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (stringArray.length != 2) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] objectArray = Strings.getNames(stringArray);
        String[] stringArray2 = Strings.getValues(stringArray);
        if (!Arrays.equals(objectArray, BLANK) && !Arrays.equals(objectArray, XY)) {
            throw new ParseException(standardMessage, -1);
        }
        objectArray = XY;
        double[] dArray = null;
        try {
            dArray = Strings.stringsToDoubles(stringArray2);
        }
        catch (ParseException parseException) {
            throw Strings.makeAdjustedParseException(parseException, "XPoint2D", (String[])objectArray);
        }
        this.setValue(dArray[0], dArray[1]);
    }

    public void setValue(double d, double d2) {
        double d3 = this.x;
        double d4 = this.y;
        if (d != d3 || d2 != d4) {
            this.x = d;
            this.y = d2;
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void setValue(Point2D point2D) {
        if (point2D != null) {
            this.setValue(point2D.getX(), point2D.getY());
        }
    }

    public void setValue(double[] dArray) {
        if (dArray == null || dArray.length != 2) {
            return;
        }
        this.setValue(dArray[0], dArray[1]);
    }

    public void setValue(float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setValue(fArray[0], fArray[1]);
    }

    public void setLocation(double d, double d2) {
        this.setValue(d, d2);
    }

    public void setLocation(Point2D point2D) {
        this.setValue(point2D);
    }

    public void setLocation(double[] dArray) {
        if (dArray == null || dArray.length != 2) {
            return;
        }
        this.setValue(dArray[0], dArray[1]);
    }

    public void setLocation(float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setValue(fArray[0], fArray[1]);
    }

    public void move(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        this.setValue(d3 + d, d4 + d2);
    }

    public void move(Point2D point2D) {
        if (point2D != null) {
            this.move(point2D.getX(), point2D.getY());
        }
    }

    public double[] toDoubleArray() {
        return new double[]{this.x, this.y};
    }

    public float[] toFloatArray() {
        return new float[]{(float)this.x, (float)this.y};
    }

    public double radius() {
        return this.distance(0.0, 0.0);
    }

    public double radiusSq() {
        return this.distanceSq(0.0, 0.0);
    }

    public double angleInRadians() {
        return XPoint2D.angleInRadians(1.0, 0.0, this.x, this.y);
    }

    public static double angleInRadians(Point2D point2D, Point2D point2D2) {
        if (point2D != null && point2D2 != null) {
            return XPoint2D.angleInRadians(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        }
        return 0.0;
    }

    public static double angleInRadians(double d, double d2, double d3, double d4) {
        double d5 = Math.atan2(d4, d3) - Math.atan2(d2, d);
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        return d5;
    }

    public double angleInDegrees() {
        return Math.toDegrees(this.angleInRadians());
    }

    public static double angleInDegrees(Point2D point2D, Point2D point2D2) {
        return Math.toDegrees(XPoint2D.angleInRadians(point2D, point2D2));
    }

    public static double angleInDegrees(double d, double d2, double d3, double d4) {
        return Math.toDegrees(XPoint2D.angleInRadians(d, d2, d3, d4));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }
}

