/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Function;
import edu.neu.ccs.util.MathUtilities;

public class F {
    private static final double logOf2 = Math.log(2.0);
    private static final double logOf10 = Math.log(10.0);
    public static final Function.OneArg identity = new 1();
    public static final Function.OneArg abs = new 2();
    public static final Function.OneArg ceil = new 3();
    public static final Function.OneArg floor = new 4();
    public static final Function.OneArg rint = new 5();
    public static final Function.OneArg sin = new 6();
    public static final Function.OneArg cos = new 7();
    public static final Function.OneArg tan = new 8();
    public static final Function.OneArg asin = new 9();
    public static final Function.OneArg acos = new 10();
    public static final Function.OneArg atan = new 11();
    public static final Function.OneArg sindeg = new 12();
    public static final Function.OneArg cosdeg = new 13();
    public static final Function.OneArg tandeg = new 14();
    public static final Function.OneArg asindeg = new 15();
    public static final Function.OneArg acosdeg = new 16();
    public static final Function.OneArg atandeg = new 17();
    public static final Function.OneArg toDegrees = new 18();
    public static final Function.OneArg toRadians = new 19();
    public static final Function.OneArg exp = new 20();
    public static final Function.OneArg log = new 21();
    public static final Function.OneArg exp2 = new 22();
    public static final Function.OneArg log2 = new 23();
    public static final Function.OneArg exp10 = new 24();
    public static final Function.OneArg log10 = new 25();
    public static final Function.OneArg sqrt = new 26();
    public static final Function.OneArg random = new 27();

    private F() {
    }

    public static Function.OneArg constant(double c) {
        return new 28(c);
    }

    public static Function.OneArg scale(double a) {
        return new 29(a);
    }

    public static Function.OneArg translate(double b) {
        return new 30(b);
    }

    public static Function.OneArg linear(double a, double b) {
        return new 31(a, b);
    }

    public static Function.OneArg xToPowerN(int n) {
        return new 32(n);
    }

    public static Function.OneArg xToPowerA(double a) {
        return new 33(a);
    }

    public static Function.OneArg aToPowerX(double a) {
        return new 34(a);
    }

    public static Function.OneArg randomDouble(double min, double max) {
        return new 35(max, min);
    }

    public static Function.OneArg add(Function.OneArg f, Function.OneArg g) {
        F.checkNull("add", f, g);
        return new 36(f, g);
    }

    public static Function.OneArg subtract(Function.OneArg f, Function.OneArg g) {
        F.checkNull("subtract", f, g);
        return new 37(f, g);
    }

    public static Function.OneArg multiply(Function.OneArg f, Function.OneArg g) {
        F.checkNull("multiply", f, g);
        return new 38(f, g);
    }

    public static Function.OneArg divide(Function.OneArg f, Function.OneArg g) {
        F.checkNull("divide", f, g);
        return new 39(f, g);
    }

    public static Function.OneArg compose(Function.OneArg f, Function.OneArg g) {
        F.checkNull("compose", f, g);
        return new 40(f, g);
    }

    public static Function.OneArg min(Function.OneArg f, Function.OneArg g) {
        F.checkNull("min", f, g);
        return new 41(f, g);
    }

    public static Function.OneArg max(Function.OneArg f, Function.OneArg g) {
        F.checkNull("max", f, g);
        return new 42(f, g);
    }

    public static Function.OneArg power(Function.OneArg f, int n) {
        F.checkNull("power", f);
        return new 43(f, n);
    }

    public static Function.OneArg pow(Function.OneArg f, double a) {
        F.checkNull("pow", f);
        return new 44(a, f);
    }

    public static Function.OneArg pow(double a, Function.OneArg f) {
        F.checkNull("pow", f);
        return new 45(a, f);
    }

    public static Function.OneArg pow(Function.OneArg f, Function.OneArg g) {
        F.checkNull("pow", f, g);
        return new 46(f, g);
    }

    public static Function.OneArg atan2(Function.OneArg f, Function.OneArg g) {
        F.checkNull("atan2", f, g);
        return new 47(f, g);
    }

    public static Function.OneArg atan2deg(Function.OneArg f, Function.OneArg g) {
        F.checkNull("atan2deg", f, g);
        return new 48(f, g);
    }

    private static void checkNull(String method, Function.OneArg f) {
        if (f == null) {
            throw new NullPointerException("Null function f in F." + method);
        }
    }

    private static void checkNull(String method, Function.OneArg f, Function.OneArg g) {
        if (f == null) {
            throw new NullPointerException("Null function f in F." + method);
        }
        if (g == null) {
            throw new NullPointerException("Null function g in F." + method);
        }
    }

    private final class 1
    implements Function.OneArg {
        public double evaluate(double x) {
            return x;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.abs(x);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.ceil(x);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.floor(x);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.rint(x);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.sin(x);
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.cos(x);
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.tan(x);
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.asin(x);
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.acos(x);
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.atan(x);
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements Function.OneArg {
        public double evaluate(double x) {
            return MathUtilities.sindeg(x);
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements Function.OneArg {
        public double evaluate(double x) {
            return MathUtilities.cosdeg(x);
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements Function.OneArg {
        public double evaluate(double x) {
            return MathUtilities.tandeg(x);
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements Function.OneArg {
        public double evaluate(double x) {
            return MathUtilities.asindeg(x);
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements Function.OneArg {
        public double evaluate(double x) {
            return MathUtilities.acosdeg(x);
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements Function.OneArg {
        public double evaluate(double x) {
            return MathUtilities.atandeg(x);
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.toDegrees(x);
        }

        /* synthetic */ 18() {
        }
    }

    private final class 19
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.toRadians(x);
        }

        /* synthetic */ 19() {
        }
    }

    private final class 20
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.exp(x);
        }

        /* synthetic */ 20() {
        }
    }

    private final class 21
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.log(x);
        }

        /* synthetic */ 21() {
        }
    }

    private final class 22
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.exp(x * logOf2);
        }

        /* synthetic */ 22() {
        }
    }

    private final class 23
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.log(x) / logOf2;
        }

        /* synthetic */ 23() {
        }
    }

    private final class 24
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.exp(x * logOf10);
        }

        /* synthetic */ 24() {
        }
    }

    private final class 25
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.log(x) / logOf10;
        }

        /* synthetic */ 25() {
        }
    }

    private final class 26
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.sqrt(x);
        }

        /* synthetic */ 26() {
        }
    }

    private final class 27
    implements Function.OneArg {
        public double evaluate(double x) {
            return Math.random();
        }

        /* synthetic */ 27() {
        }
    }

    private static final class 28
    implements Function.OneArg {
        private final /* synthetic */ double val$c;

        public double evaluate(double x) {
            return this.val$c;
        }

        /* synthetic */ 28(double val$c) {
            this.val$c = val$c;
        }
    }

    private static final class 29
    implements Function.OneArg {
        private final /* synthetic */ double val$a;

        public double evaluate(double x) {
            return this.val$a * x;
        }

        /* synthetic */ 29(double val$a) {
            this.val$a = val$a;
        }
    }

    private static final class 30
    implements Function.OneArg {
        private final /* synthetic */ double val$b;

        public double evaluate(double x) {
            return x + this.val$b;
        }

        /* synthetic */ 30(double val$b) {
            this.val$b = val$b;
        }
    }

    private static final class 31
    implements Function.OneArg {
        private final /* synthetic */ double val$b;
        private final /* synthetic */ double val$a;

        public double evaluate(double x) {
            return this.val$a * x + this.val$b;
        }

        /* synthetic */ 31(double val$a, double val$b) {
            this.val$a = val$a;
            this.val$b = val$b;
        }
    }

    private static final class 32
    implements Function.OneArg {
        private final /* synthetic */ int val$n;

        public double evaluate(double x) {
            return MathUtilities.power(x, this.val$n);
        }

        /* synthetic */ 32(int val$n) {
            this.val$n = val$n;
        }
    }

    private static final class 33
    implements Function.OneArg {
        private final /* synthetic */ double val$a;

        public double evaluate(double x) {
            return Math.pow(x, this.val$a);
        }

        /* synthetic */ 33(double val$a) {
            this.val$a = val$a;
        }
    }

    private static final class 34
    implements Function.OneArg {
        private final /* synthetic */ double val$a;

        public double evaluate(double x) {
            return Math.pow(this.val$a, x);
        }

        /* synthetic */ 34(double val$a) {
            this.val$a = val$a;
        }
    }

    private static final class 35
    implements Function.OneArg {
        private final /* synthetic */ double val$max;
        private final /* synthetic */ double val$min;

        public double evaluate(double x) {
            return MathUtilities.randomDouble(this.val$min, this.val$max);
        }

        /* synthetic */ 35(double val$max, double val$min) {
            this.val$max = val$max;
            this.val$min = val$min;
        }
    }

    private static final class 36
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return this.val$f.evaluate(x) + this.val$g.evaluate(x);
        }

        /* synthetic */ 36(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 37
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return this.val$f.evaluate(x) - this.val$g.evaluate(x);
        }

        /* synthetic */ 37(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 38
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return this.val$f.evaluate(x) * this.val$g.evaluate(x);
        }

        /* synthetic */ 38(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 39
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return this.val$f.evaluate(x) / this.val$g.evaluate(x);
        }

        /* synthetic */ 39(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 40
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return this.val$f.evaluate(this.val$g.evaluate(x));
        }

        /* synthetic */ 40(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 41
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return Math.min(this.val$f.evaluate(x), this.val$g.evaluate(x));
        }

        /* synthetic */ 41(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 42
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return Math.max(this.val$f.evaluate(x), this.val$g.evaluate(x));
        }

        /* synthetic */ 42(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 43
    implements Function.OneArg {
        private final /* synthetic */ int val$n;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return MathUtilities.power(this.val$f.evaluate(x), this.val$n);
        }

        /* synthetic */ 43(Function.OneArg val$f, int val$n) {
            this.val$f = val$f;
            this.val$n = val$n;
        }
    }

    private static final class 44
    implements Function.OneArg {
        private final /* synthetic */ double val$a;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return Math.pow(this.val$f.evaluate(x), this.val$a);
        }

        /* synthetic */ 44(double val$a, Function.OneArg val$f) {
            this.val$a = val$a;
            this.val$f = val$f;
        }
    }

    private static final class 45
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$f;
        private final /* synthetic */ double val$a;

        public double evaluate(double x) {
            return Math.pow(this.val$a, this.val$f.evaluate(x));
        }

        /* synthetic */ 45(double val$a, Function.OneArg val$f) {
            this.val$a = val$a;
            this.val$f = val$f;
        }
    }

    private static final class 46
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return Math.pow(this.val$f.evaluate(x), this.val$g.evaluate(x));
        }

        /* synthetic */ 46(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 47
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return Math.atan2(this.val$f.evaluate(x), this.val$g.evaluate(x));
        }

        /* synthetic */ 47(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }

    private static final class 48
    implements Function.OneArg {
        private final /* synthetic */ Function.OneArg val$g;
        private final /* synthetic */ Function.OneArg val$f;

        public double evaluate(double x) {
            return MathUtilities.atan2deg(this.val$f.evaluate(x), this.val$g.evaluate(x));
        }

        /* synthetic */ 48(Function.OneArg val$f, Function.OneArg val$g) {
            this.val$f = val$f;
            this.val$g = val$g;
        }
    }
}

