/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner {
    public void runTests(Class cls) throws Throwable {
        Constructor c = cls.getConstructor(new Class[0]);
        if (c == null) {
            c = cls.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
        }
        Object o = c.newInstance(new Object[0]);
        this.runTests(o);
    }

    public void runTests(Object o) {
        try {
            this.runTests(o, o.getClass());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void runTests(Object o, Class cls) throws Throwable {
        HashMap<String, Method> names2methods = new HashMap<String, Method>();
        this.getNames(o, cls.getMethods(), names2methods);
        Class c = cls;
        while (c != Object.class) {
            this.getNames(o, c.getDeclaredMethods(), names2methods);
            c = c.getSuperclass();
        }
        for (Method m : names2methods.values()) {
            this.runTest(o, m);
        }
    }

    private void getNames(Object o, Method[] ms, Map<String, Method> names2methods) throws Throwable {
        Method[] methodArray = ms;
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method m = methodArray[n];
            m.setAccessible(true);
            if (m.getName().startsWith("test") && m.getParameterTypes().length == 0 && !Modifier.isAbstract(m.getModifiers())) {
                names2methods.put(m.getName(), m);
            }
            ++n;
        }
    }

    private void runTest(Object o, Method m) throws Throwable {
        this.start(m);
        try {
            m.invoke(o, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        this.done(m);
    }

    private void note(Object msg) {
        System.err.println(msg);
    }

    private void done(Method m) {
        this.note("Done " + m.getName());
    }

    private void start(Method m) {
        this.note("Starting " + m.getName());
    }
}

