/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;

public class Transform1D
implements Cloneable,
Serializable {
    protected double factor = 1.0;
    protected double offset = 0.0;

    public Transform1D() {
    }

    public Transform1D(double d, double d2) {
        this.setTransform(d, d2);
    }

    public Transform1D(double d, double d2, double d3, double d4) {
        this.setTransform(d, d2, d3, d4);
    }

    public void setTransform(double d, double d2) {
        this.factor = d;
        this.offset = d2;
    }

    public void setTransform(double d, double d2, double d3, double d4) {
        double d5 = (d + d2) / 2.0;
        double d6 = (d3 + d4) / 2.0;
        double d7 = d2 - d;
        double d8 = d4 - d3;
        this.factor = d7 != 0.0 ? d8 / d7 : 0.0;
        this.offset = d6 - this.factor * d5;
    }

    public void setTransform(Transform1D transform1D) {
        this.factor = transform1D.factor;
        this.offset = transform1D.offset;
    }

    public void setFactor(double d) {
        this.factor = d;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public double getOffset() {
        return this.offset;
    }

    public double transform(double d) {
        return this.factor * d + this.offset;
    }

    public boolean hasInverse() {
        return this.factor != 0.0;
    }

    public double inverseTransform(double d) throws NoninvertibleTransformException {
        if (this.hasInverse()) {
            return (d - this.offset) / this.factor;
        }
        throw new NoninvertibleTransformException("Transform1D has no inverse");
    }

    public Transform1D createInverse() throws NoninvertibleTransformException {
        if (this.hasInverse()) {
            return new Transform1D(1.0 / this.factor, -this.offset / this.factor);
        }
        throw new NoninvertibleTransformException("Transform1D has no inverse");
    }
}

