/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.quick.QuickHashMap;
import edu.neu.ccs.quick.StringObjectMap;
import edu.neu.ccs.quick.StringObjectPair;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioPanel
extends JPanel
implements Displayable,
JPTConstants {
    public static final String OPTION_COUNT = "option.count";
    public static final String SELECTED_INDEX = "selected.index";
    public static final String SELECTED_LABEL = "selected.label";
    public static final String SELECTED_BUTTON = "selected.button";
    public static final String SET_LABEL_TEXT = "set.label.text";
    public static final String BACKGROUND = "set.background";
    protected static final int DEFAULT_SELECTION = 0;
    protected String defaultViewState = "";
    protected StringObjectMap labelButtonMap = new StringObjectMap();
    protected QuickHashMap labelIndexMap = new QuickHashMap();
    protected QuickHashMap modelButtonMap = new QuickHashMap();
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected TableLayout defaultLayout = new TableLayout(1, 1, 0, 0, 7, 1);
    protected ActionSequence commonactions = new ActionSequence();

    public RadioPanel() {
        this.initializeRadioPanel(null, 0, null);
    }

    public RadioPanel(LayoutManager layoutManager) {
        this.initializeRadioPanel(null, 0, layoutManager);
    }

    public RadioPanel(String[] stringArray) {
        this.initializeRadioPanel(stringArray, 0, null);
    }

    public RadioPanel(String[] stringArray, LayoutManager layoutManager) {
        this.initializeRadioPanel(stringArray, 0, layoutManager);
    }

    public RadioPanel(String[] stringArray, int n) {
        this.initializeRadioPanel(stringArray, n, null);
    }

    public RadioPanel(String[] stringArray, int n, LayoutManager layoutManager) {
        this.initializeRadioPanel(stringArray, n, layoutManager);
    }

    public RadioPanel(String[] stringArray, ActionListener actionListener) {
        this.addActionListener(actionListener);
        this.initializeRadioPanel(stringArray, 0, null);
    }

    public RadioPanel(String[] stringArray, ActionListener actionListener, LayoutManager layoutManager) {
        this.addActionListener(actionListener);
        this.initializeRadioPanel(stringArray, 0, layoutManager);
    }

    public RadioPanel(String[] stringArray, ActionListener actionListener, int n) {
        this.addActionListener(actionListener);
        this.initializeRadioPanel(stringArray, n, null);
    }

    public RadioPanel(String[] stringArray, ActionListener actionListener, int n, LayoutManager layoutManager) {
        this.addActionListener(actionListener);
        this.initializeRadioPanel(stringArray, n, layoutManager);
    }

    public RadioPanel(String[] stringArray, ActionListener[] actionListenerArray) {
        this.initializeRadioPanel(stringArray, 0, null);
        this.addActionListeners(actionListenerArray);
    }

    public RadioPanel(String[] stringArray, ActionListener[] actionListenerArray, LayoutManager layoutManager) {
        this.initializeRadioPanel(stringArray, 0, layoutManager);
        this.addActionListeners(actionListenerArray);
    }

    public RadioPanel(String[] stringArray, ActionListener[] actionListenerArray, int n) {
        this.initializeRadioPanel(stringArray, n, null);
        this.addActionListeners(actionListenerArray);
    }

    public RadioPanel(String[] stringArray, ActionListener[] actionListenerArray, int n, LayoutManager layoutManager) {
        this.initializeRadioPanel(stringArray, n, layoutManager);
        this.addActionListeners(actionListenerArray);
    }

    protected final void initializeRadioPanel(String[] stringArray, int n, LayoutManager layoutManager) {
        super.setFont(RadioPanel.getDefaultFont());
        if (layoutManager == null) {
            layoutManager = this.defaultLayout;
        }
        this.setLayout(layoutManager);
        this.addOptions(stringArray);
        this.setSelectedIndex(n);
        this.setDefaultViewState(this.getViewState());
    }

    public final int getIndex(String string) {
        if (string == null) {
            return -1;
        }
        if (!this.labelButtonMap.containsString(string)) {
            return -1;
        }
        Integer n = (Integer)this.labelIndexMap.get(string);
        return n;
    }

    public final int getIndex(JRadioButton jRadioButton) {
        return this.getIndex(this.getLabel(jRadioButton));
    }

    public final String getLabel(int n) {
        return this.labelButtonMap.getString(n);
    }

    public final String getLabel(JRadioButton jRadioButton) {
        if (jRadioButton == null) {
            return null;
        }
        if (!this.labelButtonMap.containsObject(jRadioButton)) {
            return null;
        }
        return jRadioButton.getText();
    }

    public final JRadioButton getOptionButton(int n) {
        return (JRadioButton)this.labelButtonMap.getObject(n);
    }

    public final JRadioButton getOptionButton(String string) {
        return (JRadioButton)this.labelButtonMap.getObject(string);
    }

    protected final JRadioButton getOptionButton(ButtonModel buttonModel) {
        return (JRadioButton)this.modelButtonMap.get(buttonModel);
    }

    protected final ButtonModel getButtonModel(JRadioButton jRadioButton) {
        if (jRadioButton == null) {
            return null;
        }
        if (!this.labelButtonMap.containsObject(jRadioButton)) {
            return null;
        }
        return jRadioButton.getModel();
    }

    public final boolean setSelectedIndex(int n) {
        if (this.getOptionCount() == 0) {
            return false;
        }
        int n2 = this.getSelectedIndex();
        if (n == n2) {
            return false;
        }
        ButtonModel buttonModel = this.getButtonModel(this.getOptionButton(n));
        if (buttonModel == null) {
            return false;
        }
        this.buttonGroup.setSelected(buttonModel, true);
        this.repaint();
        this.firePropertyChange(SELECTED_INDEX, n2, n);
        return true;
    }

    public final int getSelectedIndex() {
        return this.getIndex(this.getSelectedButton());
    }

    public final boolean setSelectedLabel(String string) {
        if (this.getOptionCount() == 0) {
            return false;
        }
        if (string == null) {
            return false;
        }
        String string2 = this.getSelectedLabel();
        if (string.equals(string2)) {
            return false;
        }
        ButtonModel buttonModel = this.getButtonModel(this.getOptionButton(string));
        if (buttonModel == null) {
            return false;
        }
        this.buttonGroup.setSelected(buttonModel, true);
        this.repaint();
        this.firePropertyChange(SELECTED_LABEL, string2, string);
        return true;
    }

    public final String getSelectedLabel() {
        return this.getLabel(this.getSelectedButton());
    }

    public final boolean setSelectedButton(JRadioButton jRadioButton) {
        if (this.getOptionCount() == 0) {
            return false;
        }
        if (jRadioButton == null) {
            return false;
        }
        JRadioButton jRadioButton2 = this.getSelectedButton();
        if (jRadioButton == jRadioButton2) {
            return false;
        }
        ButtonModel buttonModel = this.getButtonModel(jRadioButton);
        if (buttonModel == null) {
            return false;
        }
        this.buttonGroup.setSelected(buttonModel, true);
        this.repaint();
        this.firePropertyChange(SELECTED_BUTTON, jRadioButton2, jRadioButton);
        return true;
    }

    public final JRadioButton getSelectedButton() {
        if (this.getOptionCount() == 0) {
            return null;
        }
        return this.getOptionButton(this.buttonGroup.getSelection());
    }

    public final boolean setLabelText(int n, String string) {
        if (n < 0 || n >= this.getOptionCount()) {
            return false;
        }
        if (string == null) {
            return false;
        }
        StringObjectPair stringObjectPair = this.labelButtonMap.remove(n);
        String string2 = stringObjectPair.getString();
        JRadioButton jRadioButton = (JRadioButton)stringObjectPair.getObject();
        if (this.labelButtonMap.containsString(string)) {
            this.labelButtonMap.addPair(n, stringObjectPair);
            return false;
        }
        this.labelIndexMap.remove(string2);
        this.labelButtonMap.addPair(n, string, jRadioButton);
        this.labelIndexMap.put(string, new Integer(n));
        jRadioButton.setText(string);
        this.refreshComponent();
        this.firePropertyChange(SET_LABEL_TEXT, string2, string);
        return true;
    }

    public final String getLabelText(int n) {
        return this.getLabel(n);
    }

    public final void addOption(String string) {
        this.addOption(string, null, false);
    }

    public final void addOption(String string, Action action) {
        this.addOption(string, action, false);
    }

    public final void addOption(String string, boolean bl) {
        this.addOption(string, null, bl);
    }

    public final void addOption(String string, Action action, boolean bl) {
        if (string == null) {
            return;
        }
        if (this.labelButtonMap.containsString(string)) {
            return;
        }
        int n = this.labelButtonMap.size();
        if (n == 0) {
            bl = true;
            this.setDefaultViewState(string);
        }
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setFont(this.getFont());
        ButtonModel buttonModel = jRadioButton.getModel();
        this.labelButtonMap.addPair(string, jRadioButton);
        this.labelIndexMap.put(string, new Integer(n));
        this.modelButtonMap.put(buttonModel, jRadioButton);
        jRadioButton.addActionListener(this.commonactions);
        if (action != null) {
            jRadioButton.addActionListener(action);
        }
        this.buttonGroup.add(jRadioButton);
        this.buttonGroup.setSelected(buttonModel, bl);
        this.add(jRadioButton);
        this.refreshComponent();
        this.firePropertyChange(OPTION_COUNT, n, n + 1);
    }

    public final void addOptions(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addOption(stringArray[n]);
            ++n;
        }
    }

    public final void addOptions(String[] stringArray, Action action) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addOption(stringArray[n], action);
            ++n;
        }
    }

    public final void addOptions(String[] stringArray, Action[] actionArray) {
        if (stringArray == null) {
            return;
        }
        int n = actionArray != null ? actionArray.length : 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 < n) {
                this.addOption(stringArray[n2], actionArray[n2]);
            } else {
                this.addOption(stringArray[n2]);
            }
            ++n2;
        }
    }

    public final int getOptionCount() {
        return this.labelButtonMap.size();
    }

    public final JRadioButton[] getOptionButtons() {
        if (this.labelButtonMap == null) {
            return new JRadioButton[0];
        }
        Object[] objectArray = this.labelButtonMap.getObjects();
        int n = objectArray.length;
        JRadioButton[] jRadioButtonArray = new JRadioButton[n];
        int n2 = 0;
        while (n2 < n) {
            jRadioButtonArray[n2] = (JRadioButton)objectArray[n2];
            ++n2;
        }
        return jRadioButtonArray;
    }

    public final void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.commonactions.add(actionListener);
    }

    public final void addActionListener(int n, ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        if (n < 0 || n >= this.getOptionCount()) {
            return;
        }
        this.getOptionButton(n).addActionListener(actionListener);
    }

    public final void addActionListeners(ActionListener[] actionListenerArray) {
        if (actionListenerArray == null) {
            return;
        }
        int n = Math.min(this.getOptionCount(), actionListenerArray.length);
        int n2 = 0;
        while (n2 < n) {
            this.addActionListener(n2, actionListenerArray[n2]);
            ++n2;
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.commonactions.remove(actionListener);
    }

    public final void removeActionListener(int n, ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        if (n < 0 || n >= this.getOptionCount()) {
            return;
        }
        this.getOptionButton(n).removeActionListener(actionListener);
    }

    public final void removeActionListeners(ActionListener[] actionListenerArray) {
        if (actionListenerArray == null) {
            return;
        }
        int n = Math.min(this.getOptionCount(), actionListenerArray.length);
        int n2 = 0;
        while (n2 < n) {
            this.removeActionListener(n2, actionListenerArray[n2]);
            ++n2;
        }
    }

    public void setFont(Font font) {
        if (this.labelButtonMap == null) {
            super.setFont(font);
            return;
        }
        if (font == null) {
            font = RadioPanel.getDefaultFont();
        }
        super.setFont(font);
        JRadioButton[] jRadioButtonArray = this.getOptionButtons();
        int n = jRadioButtonArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                jRadioButtonArray[n2].setFont(font);
                ++n2;
            }
        }
        this.refreshComponent();
        this.firePropertyChange("set.font", null, null);
    }

    public static Font getDefaultFont() {
        return new JRadioButton(" ").getFont();
    }

    public void setBackground(Color color) {
        if (this.labelButtonMap == null) {
            super.setBackground(color);
            return;
        }
        if (color == null) {
            color = RadioPanel.getDefaultBackground();
        }
        super.setBackground(color);
        JRadioButton[] jRadioButtonArray = this.getOptionButtons();
        int n = jRadioButtonArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                jRadioButtonArray[n2].setBackground(color);
                ++n2;
            }
        }
        this.repaint();
        this.firePropertyChange(BACKGROUND, null, null);
    }

    public static Color getDefaultBackground() {
        return new JRadioButton(" ").getBackground();
    }

    public void setViewState(String string) {
        String string2 = this.getSelectedLabel();
        if (this.setSelectedLabel(string)) {
            this.firePropertyChange("view.state", string2, string);
        }
    }

    public String getViewState() {
        return this.getSelectedLabel();
    }

    public void setDefaultViewState(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getDefaultViewState();
        if (string.equals(string2)) {
            return;
        }
        this.defaultViewState = string;
        this.firePropertyChange("default.view.state", string2, string);
    }

    public String getDefaultViewState() {
        return this.defaultViewState;
    }

    public final void reset() {
        this.setViewState(this.getDefaultViewState());
    }

    public final void setEnabled(boolean bl) {
        int n = this.getOptionCount();
        int n2 = 0;
        while (n2 < n) {
            this.getOptionButton(n2).setEnabled(bl);
            ++n2;
        }
        super.setEnabled(bl);
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }
}

