/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PlotMarkAlgorithm;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class PlotMark {
    public static final PlotMark H_BAR = new PlotMark(PlotMarkAlgorithm.HBar, false);
    public static final PlotMark V_BAR = new PlotMark(PlotMarkAlgorithm.VBar, false);
    public static final PlotMark PLUS = new PlotMark(PlotMarkAlgorithm.Plus, false);
    public static final PlotMark CROSS = new PlotMark(PlotMarkAlgorithm.Cross, false);
    public static final PlotMark ASTERISK = new PlotMark(PlotMarkAlgorithm.Asterisk, false);
    public static final PlotMark SQUARE = new PlotMark(PlotMarkAlgorithm.Square, false);
    public static final PlotMark CIRCLE = new PlotMark(PlotMarkAlgorithm.Circle, false);
    public static final PlotMark DIAMOND = new PlotMark(PlotMarkAlgorithm.Diamond, false);
    public static final PlotMark WEDGE_N = new PlotMark(PlotMarkAlgorithm.WedgeN, false);
    public static final PlotMark WEDGE_E = new PlotMark(PlotMarkAlgorithm.WedgeE, false);
    public static final PlotMark WEDGE_S = new PlotMark(PlotMarkAlgorithm.WedgeS, false);
    public static final PlotMark WEDGE_W = new PlotMark(PlotMarkAlgorithm.WedgeW, false);
    public static final PlotMark BLUNT_WEDGE_N = new PlotMark(PlotMarkAlgorithm.BluntWedgeN, false);
    public static final PlotMark BLUNT_WEDGE_E = new PlotMark(PlotMarkAlgorithm.BluntWedgeE, false);
    public static final PlotMark BLUNT_WEDGE_S = new PlotMark(PlotMarkAlgorithm.BluntWedgeS, false);
    public static final PlotMark BLUNT_WEDGE_W = new PlotMark(PlotMarkAlgorithm.BluntWedgeW, false);
    public static final PlotMark SHARP_WEDGE_N = new PlotMark(PlotMarkAlgorithm.SharpWedgeN, false);
    public static final PlotMark SHARP_WEDGE_E = new PlotMark(PlotMarkAlgorithm.SharpWedgeE, false);
    public static final PlotMark SHARP_WEDGE_S = new PlotMark(PlotMarkAlgorithm.SharpWedgeS, false);
    public static final PlotMark SHARP_WEDGE_W = new PlotMark(PlotMarkAlgorithm.SharpWedgeW, false);
    public static final PlotMark FILLED_SQUARE = new PlotMark(PlotMarkAlgorithm.Square, true);
    public static final PlotMark FILLED_CIRCLE = new PlotMark(PlotMarkAlgorithm.Circle, true);
    public static final PlotMark FILLED_DIAMOND = new PlotMark(PlotMarkAlgorithm.Diamond, true);
    public static final PlotMark FILLED_WEDGE_N = new PlotMark(PlotMarkAlgorithm.WedgeN, true);
    public static final PlotMark FILLED_WEDGE_E = new PlotMark(PlotMarkAlgorithm.WedgeE, true);
    public static final PlotMark FILLED_WEDGE_S = new PlotMark(PlotMarkAlgorithm.WedgeS, true);
    public static final PlotMark FILLED_WEDGE_W = new PlotMark(PlotMarkAlgorithm.WedgeW, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_N = new PlotMark(PlotMarkAlgorithm.BluntWedgeN, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_E = new PlotMark(PlotMarkAlgorithm.BluntWedgeE, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_S = new PlotMark(PlotMarkAlgorithm.BluntWedgeS, true);
    public static final PlotMark FILLED_BLUNT_WEDGE_W = new PlotMark(PlotMarkAlgorithm.BluntWedgeW, true);
    public static final PlotMark FILLED_SHARP_WEDGE_N = new PlotMark(PlotMarkAlgorithm.SharpWedgeN, true);
    public static final PlotMark FILLED_SHARP_WEDGE_E = new PlotMark(PlotMarkAlgorithm.SharpWedgeE, true);
    public static final PlotMark FILLED_SHARP_WEDGE_S = new PlotMark(PlotMarkAlgorithm.SharpWedgeS, true);
    public static final PlotMark FILLED_SHARP_WEDGE_W = new PlotMark(PlotMarkAlgorithm.SharpWedgeW, true);
    private static final PlotMarkAlgorithm DEFAULT_ALGORITHM = PlotMarkAlgorithm.Square;
    private static final int DEFAULT_SIZE = 3;
    private static final boolean DEFAULT_FILL = true;
    private static final Stroke standardStroke = new BasicStroke(1.0f);
    protected PlotMarkAlgorithm algorithm = DEFAULT_ALGORITHM;
    protected int size = 3;
    protected boolean fill = true;
    protected Paintable paintable = null;

    public PlotMark() {
    }

    public PlotMark(PlotMarkAlgorithm plotMarkAlgorithm) {
        this.initializePlotMark(plotMarkAlgorithm, 3, true, null);
    }

    public PlotMark(PlotMarkAlgorithm plotMarkAlgorithm, int n) {
        this.initializePlotMark(plotMarkAlgorithm, n, true, null);
    }

    public PlotMark(PlotMarkAlgorithm plotMarkAlgorithm, boolean bl) {
        this.initializePlotMark(plotMarkAlgorithm, 3, bl, null);
    }

    public PlotMark(PlotMarkAlgorithm plotMarkAlgorithm, int n, boolean bl) {
        this.initializePlotMark(plotMarkAlgorithm, n, bl, null);
    }

    public PlotMark(PlotMark plotMark) {
        if (plotMark == null) {
            plotMark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotMark.algorithm, plotMark.size, plotMark.fill, plotMark.paintable);
    }

    public PlotMark(PlotMark plotMark, int n) {
        if (plotMark == null) {
            plotMark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotMark.algorithm, n, plotMark.fill, plotMark.paintable);
    }

    public PlotMark(PlotMark plotMark, boolean bl) {
        if (plotMark == null) {
            plotMark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotMark.algorithm, plotMark.size, bl, plotMark.paintable);
    }

    public PlotMark(PlotMark plotMark, int n, boolean bl) {
        if (plotMark == null) {
            plotMark = FILLED_SQUARE;
        }
        this.initializePlotMark(plotMark.algorithm, n, bl, plotMark.paintable);
    }

    public PlotMark(Paintable paintable) {
        this.initializePlotMark(DEFAULT_ALGORITHM, 3, true, paintable);
    }

    private void initializePlotMark(PlotMarkAlgorithm plotMarkAlgorithm, int n, boolean bl, Paintable paintable) {
        if (paintable != null) {
            this.algorithm = null;
            this.paintable = paintable;
            return;
        }
        if (plotMarkAlgorithm == null) {
            plotMarkAlgorithm = PlotMarkAlgorithm.Square;
        }
        this.algorithm = plotMarkAlgorithm;
        if (n < 1) {
            n = 1;
        }
        this.size = n;
        this.fill = bl;
    }

    public final void mark(Graphics graphics, Point2D point2D) {
        if (graphics == null) {
            return;
        }
        if (point2D == null) {
            return;
        }
        this.mark(graphics, point2D.getX(), point2D.getY());
    }

    public final void mark(Graphics graphics, double d, double d2) {
        if (graphics == null) {
            return;
        }
        if (this.algorithm != null) {
            Shape shape = this.algorithm.makeShape(d, d2, this.size);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.fill) {
                graphics2D.fill(shape);
            } else {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(standardStroke);
                graphics2D.draw(shape);
                graphics2D.setStroke(stroke);
            }
        } else if (this.paintable != null) {
            this.paintable.paintAt(graphics, d, d2);
        }
    }

    public final void mark(Graphics graphics, AffineTransform affineTransform, Point2D point2D) {
        if (graphics == null) {
            return;
        }
        if (point2D == null) {
            return;
        }
        this.mark(graphics, affineTransform, point2D.getX(), point2D.getY());
    }

    public final void mark(Graphics graphics, AffineTransform affineTransform, double d, double d2) {
        if (graphics == null) {
            return;
        }
        if (affineTransform == null || affineTransform.isIdentity()) {
            this.mark(graphics, d, d2);
        } else {
            Point2D.Double double_ = new Point2D.Double(d, d2);
            affineTransform.transform(double_, double_);
            this.mark(graphics, double_.getX(), double_.getY());
        }
    }

    public final PlotMarkAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean getFill() {
        return this.fill;
    }

    public final Paintable getPaintable() {
        return this.paintable;
    }
}

