/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.PathNode;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class PathListIterator
implements PathIterator {
    public static final int MOVE = 0;
    public static final int LINE = 1;
    public static final int QUAD = 2;
    public static final int CUBIC = 3;
    public static final int CLOSE = 4;
    protected PathList pathlist = null;
    private int pointer = 0;

    public PathListIterator() {
        this.setPathList(null);
    }

    public PathListIterator(PathList list) {
        this.setPathList(list);
    }

    public final void setPathList(PathList pathlist) {
        this.pathlist = pathlist == null ? new PathList() : pathlist;
    }

    public final PathList getPathList() {
        return this.pathlist;
    }

    public final boolean isValid() {
        return this.pathlist.isValid();
    }

    public final int getWindingRule() {
        return this.pathlist.getWindingRule().rule();
    }

    public final boolean isDone() {
        return !this.isValid() || this.pointer >= this.pathlist.size();
    }

    public final void next() {
        if (this.pointer < this.pathlist.size()) {
            ++this.pointer;
        }
    }

    public final void reset() {
        this.pointer = 0;
    }

    public final int currentSegment(float[] coords) {
        if (this.isDone()) {
            throw new IndexOutOfBoundsException("Beyond final path node in PathListIterator");
        }
        PathNode node = this.pathlist.get(this.pointer);
        return node.nodeInfo(coords);
    }

    public final int currentSegment(double[] coords) {
        if (this.isDone()) {
            throw new IndexOutOfBoundsException("Beyond final path node in PathListIterator");
        }
        PathNode node = this.pathlist.get(this.pointer);
        return node.nodeInfo(coords);
    }

    public final Shape makeShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule());
        if (!this.pathlist.isValid()) {
            return gp;
        }
        int N = this.pathlist.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.pathlist.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: {
                    gp.moveTo(node.getX1(), node.getY1());
                    break;
                }
                case 1: {
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 2: {
                    gp.quadTo(node.getX1(), node.getY1(), node.getX2(), node.getY2());
                    break;
                }
                case 3: {
                    gp.curveTo(node.getX1(), node.getY1(), node.getX2(), node.getY2(), node.getX3(), node.getY3());
                    break;
                }
                case 4: {
                    gp.closePath();
                    break;
                }
            }
            ++i;
        }
        return gp;
    }
}

