/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.PaintAlgorithm;
import edu.neu.ccs.util.MathUtilities;
import java.awt.Color;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class PaintTools {
    private PaintTools() {
    }

    public static TexturePaint makePaint(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return PaintTools.makePaint(paintAlgorithm, paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
    }

    public static TexturePaint makePaint(PaintAlgorithm paintAlgorithm, int n, int n2) {
        return new TexturePaint(PaintTools.makeBufferedImage(paintAlgorithm, n, n2), new Rectangle2D.Double(0.0, 0.0, n, n2));
    }

    public static BufferedImage makeBufferedImage(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return PaintTools.makeBufferedImage(paintAlgorithm, paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
    }

    public static BufferedImage makeBufferedImage(PaintAlgorithm paintAlgorithm, int n, int n2) {
        if (paintAlgorithm == null || n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Color color = paintAlgorithm.color(n3, n4);
                int n5 = color.getRed();
                int n6 = color.getGreen();
                int n7 = color.getBlue();
                int n8 = color.getAlpha();
                int n9 = n8 << 24 | n5 << 16 | n6 << 8 | n7;
                bufferedImage.setRGB(n3, n4, n9);
                ++n4;
            }
            ++n3;
        }
        return bufferedImage;
    }

    public static PaintAlgorithm makePaintAlgorithm(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n == 0 || n2 == 0) {
            return null;
        }
        Color[][] colorArray = new Color[n][n2];
        int n3 = bufferedImage.getMinX();
        int n4 = bufferedImage.getMinY();
        int n5 = n3 + n;
        int n6 = n4 + n2;
        int n7 = n3;
        while (n7 < n5) {
            int n8 = n4;
            while (n8 < n6) {
                colorArray[n7 - n3][n8 - n4] = new Color(bufferedImage.getRGB(n7, n8), true);
                ++n8;
            }
            ++n7;
        }
        return new 1(colorArray, n3, n4, n, n2);
    }

    public static PaintAlgorithm solid(Color color) {
        Color color2 = color != null ? color : Color.black;
        return new 2(color2);
    }

    public static PaintAlgorithm turn45(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 3(paintAlgorithm);
    }

    public static PaintAlgorithm turn90(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 4(paintAlgorithm);
    }

    public static PaintAlgorithm turn135(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 5(paintAlgorithm);
    }

    public static PaintAlgorithm turn180(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 6(paintAlgorithm);
    }

    public static PaintAlgorithm turn225(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 7(paintAlgorithm);
    }

    public static PaintAlgorithm turn270(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 8(paintAlgorithm);
    }

    public static PaintAlgorithm turn315(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 9(paintAlgorithm);
    }

    public static PaintAlgorithm reflect(PaintAlgorithm paintAlgorithm) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 10(paintAlgorithm);
    }

    public static PaintAlgorithm translate(PaintAlgorithm paintAlgorithm, int n, int n2) {
        if (paintAlgorithm == null) {
            return null;
        }
        return new 11(paintAlgorithm, n, n2);
    }

    public static PaintAlgorithm stripeEtoW(Color color, Color color2, int n, int n2) {
        return PaintTools.stripeEtoW(PaintTools.solid(color), PaintTools.solid(color2), n, n2);
    }

    public static PaintAlgorithm stripeEtoW(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2) {
        if (paintAlgorithm == null || paintAlgorithm2 == null) {
            return null;
        }
        int n3 = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm2.xPeriod());
        int n4 = n >= 1 ? n : 1;
        int n5 = n2 >= 1 ? n2 : 1;
        int n6 = n4 + n5;
        return new 12(paintAlgorithm, paintAlgorithm2, n3, n6, n4);
    }

    public static PaintAlgorithm stripeNEtoSW(Color color, Color color2, int n, int n2) {
        return PaintTools.turn45(PaintTools.stripeEtoW(PaintTools.solid(color), PaintTools.solid(color2), n, n2));
    }

    public static PaintAlgorithm stripeNEtoSW(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2) {
        return PaintTools.turn45(PaintTools.stripeEtoW(paintAlgorithm, paintAlgorithm2, n, n2));
    }

    public static PaintAlgorithm stripeNtoS(Color color, Color color2, int n, int n2) {
        return PaintTools.turn90(PaintTools.stripeEtoW(PaintTools.solid(color), PaintTools.solid(color2), n, n2));
    }

    public static PaintAlgorithm stripeNtoS(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2) {
        return PaintTools.turn90(PaintTools.stripeEtoW(paintAlgorithm, paintAlgorithm2, n, n2));
    }

    public static PaintAlgorithm stripeNWtoSE(Color color, Color color2, int n, int n2) {
        return PaintTools.turn135(PaintTools.stripeEtoW(PaintTools.solid(color), PaintTools.solid(color2), n, n2));
    }

    public static PaintAlgorithm stripeNWtoSE(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2) {
        return PaintTools.turn135(PaintTools.stripeEtoW(paintAlgorithm, paintAlgorithm2, n, n2));
    }

    public static PaintAlgorithm checkHatch(Color color, Color color2, int n, int n2, int n3, int n4) {
        return PaintTools.checkHatch(PaintTools.solid(color), PaintTools.solid(color2), n, n2, n3, n4);
    }

    public static PaintAlgorithm checkHatch(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2, int n3, int n4) {
        if (paintAlgorithm == null || paintAlgorithm2 == null) {
            return null;
        }
        int n5 = n >= 1 ? n : 1;
        int n6 = n2 >= 1 ? n2 : 1;
        int n7 = n5 + n6;
        int n8 = n3 >= 1 ? n3 : 1;
        int n9 = n4 >= 1 ? n4 : 1;
        int n10 = n8 + n9;
        return new 13(paintAlgorithm, paintAlgorithm2, n10, n8, n7, n5);
    }

    public static PaintAlgorithm checkHatchDiagonal(Color color, Color color2, int n, int n2, int n3, int n4) {
        return PaintTools.turn45(PaintTools.checkHatch(PaintTools.solid(color), PaintTools.solid(color2), n, n2, n3, n4));
    }

    public static PaintAlgorithm checkHatchDiagonal(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2, int n3, int n4) {
        return PaintTools.turn45(PaintTools.checkHatch(paintAlgorithm, paintAlgorithm2, n, n2, n3, n4));
    }

    public static PaintAlgorithm crossHatch(Color color, Color color2, int n, int n2, int n3, int n4) {
        return PaintTools.crossHatch(PaintTools.solid(color), PaintTools.solid(color2), n, n2, n3, n4);
    }

    public static PaintAlgorithm crossHatch(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2, int n3, int n4) {
        if (paintAlgorithm == null || paintAlgorithm2 == null) {
            return null;
        }
        int n5 = n >= 1 ? n : 1;
        int n6 = n2 >= 1 ? n2 : 1;
        int n7 = n5 + n6;
        int n8 = n3 >= 1 ? n3 : 1;
        int n9 = n4 >= 1 ? n4 : 1;
        int n10 = n8 + n9;
        return new 14(paintAlgorithm, paintAlgorithm2, n10, n8, n7, n5);
    }

    public static PaintAlgorithm crossHatchDiagonal(Color color, Color color2, int n, int n2, int n3, int n4) {
        return PaintTools.turn45(PaintTools.crossHatch(PaintTools.solid(color), PaintTools.solid(color2), n, n2, n3, n4));
    }

    public static PaintAlgorithm crossHatchDiagonal(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2, int n3, int n4) {
        return PaintTools.turn45(PaintTools.crossHatch(paintAlgorithm, paintAlgorithm2, n, n2, n3, n4));
    }

    public static PaintAlgorithm dottedGrid(Color color, Color color2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (color == null) {
            color = Color.black;
        }
        if (color2 == null) {
            color2 = Color.white;
        }
        if ((n6 = (n5 = n2 >= (n4 = 2 * (n3 = n >= 1 ? n : 1)) ? n2 : n4) % n4) > 0) {
            n5 += n4 - n6;
        }
        PaintAlgorithm paintAlgorithm = PaintTools.checkHatch(color, color2, n3, n3, n3, n3);
        PaintAlgorithm paintAlgorithm2 = PaintTools.solid(color2);
        int n7 = n5 - n3;
        return PaintTools.crossHatch(paintAlgorithm, paintAlgorithm2, n3, n7, n3, n7);
    }

    public static PaintAlgorithm dottedGridDiagonal(Color color, Color color2, int n, int n2) {
        return PaintTools.turn45(PaintTools.dottedGrid(color, color2, n, n2));
    }

    public static PaintAlgorithm brickEtoW(Color color, Color color2, int n) {
        if (color == null) {
            color = Colors.Brown;
        }
        if (color2 == null) {
            color2 = Color.black;
        }
        Color color3 = color;
        Color color4 = color2;
        int n2 = n >= 2 ? n : 2;
        int n3 = 2 * n2 + 4;
        int n4 = 0;
        int n5 = n2 + 1;
        int n6 = n2 + 2;
        int n7 = n2 + n2 + 3;
        return new 15(color3, color4, n3, n4, n5, n6, n7);
    }

    public static PaintAlgorithm brickNEtoSW(Color color, Color color2, int n) {
        return PaintTools.turn45(PaintTools.brickEtoW(color, color2, n));
    }

    public static PaintAlgorithm brickNtoS(Color color, Color color2, int n) {
        return PaintTools.turn90(PaintTools.brickEtoW(color, color2, n));
    }

    public static PaintAlgorithm brickNWtoSE(Color color, Color color2, int n) {
        return PaintTools.turn135(PaintTools.brickEtoW(color, color2, n));
    }

    private static final class 1
    implements PaintAlgorithm {
        private final /* synthetic */ Color[][] val$colors;
        private final /* synthetic */ int val$yperiod;
        private final /* synthetic */ int val$xperiod;
        private final /* synthetic */ int val$miny;
        private final /* synthetic */ int val$minx;

        public Color color(int n, int n2) {
            n -= this.val$minx;
            n2 -= this.val$miny;
            n = MathUtilities.modulus(n, this.val$xperiod);
            n2 = MathUtilities.modulus(n2, this.val$yperiod);
            return this.val$colors[n][n2];
        }

        public int xPeriod() {
            return this.val$xperiod;
        }

        public int yPeriod() {
            return this.val$yperiod;
        }

        /* synthetic */ 1(Color[][] colorArray, int n, int n2, int n3, int n4) {
            this.val$colors = colorArray;
            this.val$minx = n;
            this.val$miny = n2;
            this.val$xperiod = n3;
            this.val$yperiod = n4;
        }
    }

    private static final class 2
    implements PaintAlgorithm {
        private final /* synthetic */ Color val$d;

        public Color color(int n, int n2) {
            return this.val$d;
        }

        public int xPeriod() {
            return 1;
        }

        public int yPeriod() {
            return 1;
        }

        /* synthetic */ 2(Color color) {
            this.val$d = color;
        }
    }

    private static final class 3
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int period;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(n - n2, n + n2);
        }

        public int xPeriod() {
            return this.period;
        }

        public int yPeriod() {
            return this.period;
        }

        /* synthetic */ 3(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
        }
    }

    private static final class 4
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int xPeriod;
        final int yPeriod;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(-n2, n);
        }

        public int xPeriod() {
            return this.xPeriod;
        }

        public int yPeriod() {
            return this.yPeriod;
        }

        /* synthetic */ 4(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.xPeriod = paintAlgorithm.yPeriod();
            this.yPeriod = paintAlgorithm.xPeriod();
        }
    }

    private static final class 5
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int period;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(-n - n2, n - n2);
        }

        public int xPeriod() {
            return this.period;
        }

        public int yPeriod() {
            return this.period;
        }

        /* synthetic */ 5(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
        }
    }

    private static final class 6
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int xPeriod;
        final int yPeriod;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(-n, -n2);
        }

        public int xPeriod() {
            return this.xPeriod;
        }

        public int yPeriod() {
            return this.yPeriod;
        }

        /* synthetic */ 6(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.xPeriod = paintAlgorithm.xPeriod();
            this.yPeriod = paintAlgorithm.yPeriod();
        }
    }

    private static final class 7
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int period;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(-n + n2, -n - n2);
        }

        public int xPeriod() {
            return this.period;
        }

        public int yPeriod() {
            return this.period;
        }

        /* synthetic */ 7(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
        }
    }

    private static final class 8
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int xPeriod;
        final int yPeriod;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(n2, -n);
        }

        public int xPeriod() {
            return this.xPeriod;
        }

        public int yPeriod() {
            return this.yPeriod;
        }

        /* synthetic */ 8(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.xPeriod = paintAlgorithm.yPeriod();
            this.yPeriod = paintAlgorithm.xPeriod();
        }
    }

    private static final class 9
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int period;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(n + n2, -n + n2);
        }

        public int xPeriod() {
            return this.period;
        }

        public int yPeriod() {
            return this.period;
        }

        /* synthetic */ 9(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
        }
    }

    private static final class 10
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int xPeriod;
        final int yPeriod;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(n, -n2);
        }

        public int xPeriod() {
            return this.xPeriod;
        }

        public int yPeriod() {
            return this.yPeriod;
        }

        /* synthetic */ 10(PaintAlgorithm paintAlgorithm) {
            this.val$algorithm = paintAlgorithm;
            this.xPeriod = paintAlgorithm.xPeriod();
            this.yPeriod = paintAlgorithm.yPeriod();
        }
    }

    private static final class 11
    implements PaintAlgorithm {
        private final /* synthetic */ int val$y0;
        private final /* synthetic */ int val$x0;
        private final /* synthetic */ PaintAlgorithm val$algorithm;
        final int xPeriod;
        final int yPeriod;

        public Color color(int n, int n2) {
            return this.val$algorithm.color(n - this.val$x0, n2 - this.val$y0);
        }

        public int xPeriod() {
            return this.xPeriod;
        }

        public int yPeriod() {
            return this.yPeriod;
        }

        /* synthetic */ 11(PaintAlgorithm paintAlgorithm, int n, int n2) {
            this.val$algorithm = paintAlgorithm;
            this.val$x0 = n;
            this.val$y0 = n2;
            this.xPeriod = paintAlgorithm.xPeriod();
            this.yPeriod = paintAlgorithm.yPeriod();
        }
    }

    private static final class 12
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm2;
        private final /* synthetic */ PaintAlgorithm val$algorithm1;
        private final /* synthetic */ int val$t1;
        private final /* synthetic */ int val$t;
        private final /* synthetic */ int val$s;

        public Color color(int n, int n2) {
            n = MathUtilities.modulus(n, this.val$s);
            if ((n2 = MathUtilities.modulus(n2, this.val$t)) < this.val$t1) {
                return this.val$algorithm1.color(n, n2);
            }
            return this.val$algorithm2.color(n, n2);
        }

        public int xPeriod() {
            return this.val$s;
        }

        public int yPeriod() {
            return this.val$t;
        }

        /* synthetic */ 12(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2, int n3) {
            this.val$algorithm1 = paintAlgorithm;
            this.val$algorithm2 = paintAlgorithm2;
            this.val$s = n;
            this.val$t = n2;
            this.val$t1 = n3;
        }
    }

    private static final class 13
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm2;
        private final /* synthetic */ PaintAlgorithm val$algorithm1;
        private final /* synthetic */ int val$h1;
        private final /* synthetic */ int val$w1;
        private final /* synthetic */ int val$h;
        private final /* synthetic */ int val$w;

        public Color color(int n, int n2) {
            boolean bl;
            n = MathUtilities.modulus(n, this.val$w);
            n2 = MathUtilities.modulus(n2, this.val$h);
            boolean bl2 = bl = n < this.val$w1 && n2 < this.val$h1 || n >= this.val$w1 && n2 >= this.val$h1;
            if (bl) {
                return this.val$algorithm1.color(n, n2);
            }
            return this.val$algorithm2.color(n, n2);
        }

        public int xPeriod() {
            return this.val$w;
        }

        public int yPeriod() {
            return this.val$h;
        }

        /* synthetic */ 13(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2, int n3, int n4) {
            this.val$algorithm1 = paintAlgorithm;
            this.val$algorithm2 = paintAlgorithm2;
            this.val$h = n;
            this.val$h1 = n2;
            this.val$w = n3;
            this.val$w1 = n4;
        }
    }

    private static final class 14
    implements PaintAlgorithm {
        private final /* synthetic */ PaintAlgorithm val$algorithm2;
        private final /* synthetic */ PaintAlgorithm val$algorithm1;
        private final /* synthetic */ int val$h1;
        private final /* synthetic */ int val$w1;
        private final /* synthetic */ int val$h;
        private final /* synthetic */ int val$w;

        public Color color(int n, int n2) {
            boolean bl;
            n = MathUtilities.modulus(n, this.val$w);
            n2 = MathUtilities.modulus(n2, this.val$h);
            boolean bl2 = bl = n < this.val$w1 || n2 < this.val$h1;
            if (bl) {
                return this.val$algorithm1.color(n, n2);
            }
            return this.val$algorithm2.color(n, n2);
        }

        public int xPeriod() {
            return this.val$w;
        }

        public int yPeriod() {
            return this.val$h;
        }

        /* synthetic */ 14(PaintAlgorithm paintAlgorithm, PaintAlgorithm paintAlgorithm2, int n, int n2, int n3, int n4) {
            this.val$algorithm1 = paintAlgorithm;
            this.val$algorithm2 = paintAlgorithm2;
            this.val$h = n;
            this.val$h1 = n2;
            this.val$w = n3;
            this.val$w1 = n4;
        }
    }

    private static final class 15
    implements PaintAlgorithm {
        private final /* synthetic */ Color val$color1;
        private final /* synthetic */ Color val$color2;
        private final /* synthetic */ int val$z3;
        private final /* synthetic */ int val$z2;
        private final /* synthetic */ int val$z1;
        private final /* synthetic */ int val$z0;
        private final /* synthetic */ int val$z;

        public Color color(int n, int n2) {
            n = MathUtilities.modulus(n, this.val$z);
            if ((n2 = MathUtilities.modulus(n2, this.val$z)) == this.val$z0 || n2 == this.val$z1 || n2 == this.val$z2 || n2 == this.val$z3) {
                return this.val$color2;
            }
            if (n2 < this.val$z1 && (n == this.val$z0 || n == this.val$z3)) {
                return this.val$color2;
            }
            if (n2 > this.val$z2 && (n == this.val$z1 || n == this.val$z2)) {
                return this.val$color2;
            }
            return this.val$color1;
        }

        public int xPeriod() {
            return this.val$z;
        }

        public int yPeriod() {
            return this.val$z;
        }

        /* synthetic */ 15(Color color, Color color2, int n, int n2, int n3, int n4, int n5) {
            this.val$color1 = color;
            this.val$color2 = color2;
            this.val$z = n;
            this.val$z0 = n2;
            this.val$z1 = n3;
            this.val$z2 = n4;
            this.val$z3 = n5;
        }
    }
}

