/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.ShapePaintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Point2D;

public abstract class PaintMode {
    public static final PaintMode FILL = new 1();
    public static final PaintMode DRAW = new 2();
    public static final PaintMode FILL_DRAW = new 3();

    public abstract void originalPaint(ShapePaintable var1, Graphics var2);

    public abstract XRect getActualBounds2D(ShapePaintable var1);

    public abstract Shape getOutline(ShapePaintable var1);

    public abstract boolean originalContains(ShapePaintable var1, double var2, double var4);

    public final boolean originalContains(ShapePaintable shapePaintable, Point2D point2D) {
        if (point2D == null) {
            return false;
        }
        return this.originalContains(shapePaintable, point2D.getX(), point2D.getY());
    }

    public static void fill(Graphics graphics, Shape shape, Paint paint) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, FILL, paint);
        shapePaintable.paint(graphics);
    }

    public static void draw(Graphics graphics, Shape shape, Paint paint) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, DRAW, null, paint);
        shapePaintable.paint(graphics);
    }

    public static void draw(Graphics graphics, Shape shape, Paint paint, Stroke stroke) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, DRAW, null, paint, stroke);
        shapePaintable.paint(graphics);
    }

    public static void filldraw(Graphics graphics, Shape shape, Paint paint, Paint paint2) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, FILL_DRAW, paint, paint2);
        shapePaintable.paint(graphics);
    }

    public static void filldraw(Graphics graphics, Shape shape, Paint paint, Paint paint2, Stroke stroke) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, FILL_DRAW, paint, paint2, stroke);
        shapePaintable.paint(graphics);
    }

    private final class 1
    extends PaintMode {
        public void originalPaint(ShapePaintable shapePaintable, Graphics graphics) {
            if (shapePaintable == null || graphics == null) {
                return;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setPaint(shapePaintable.getFillPaint());
            graphics2D.fill(shape);
        }

        public XRect getActualBounds2D(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return new XRect();
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return new XRect();
            }
            return new XRect(shape.getBounds2D());
        }

        public Shape getOutline(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return null;
            }
            return shapePaintable.getShape();
        }

        public boolean originalContains(ShapePaintable shapePaintable, double d, double d2) {
            if (shapePaintable == null) {
                return false;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return false;
            }
            return shape.contains(d, d2);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends PaintMode {
        public void originalPaint(ShapePaintable shapePaintable, Graphics graphics) {
            if (shapePaintable == null || graphics == null) {
                return;
            }
            Shape shape = shapePaintable.getStrokedShape();
            if (shape == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setPaint(shapePaintable.getDrawPaint());
            graphics2D.fill(shape);
        }

        public XRect getActualBounds2D(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return new XRect();
            }
            Shape shape = shapePaintable.getStrokedShape();
            if (shape == null) {
                return new XRect();
            }
            return new XRect(shape.getBounds2D());
        }

        public Shape getOutline(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return null;
            }
            return shapePaintable.getStrokedShape();
        }

        public boolean originalContains(ShapePaintable shapePaintable, double d, double d2) {
            if (shapePaintable == null) {
                return false;
            }
            Shape shape = shapePaintable.getStrokedShape();
            if (shape == null) {
                return false;
            }
            return shape.contains(d, d2);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends PaintMode {
        public void originalPaint(ShapePaintable shapePaintable, Graphics graphics) {
            if (shapePaintable == null || graphics == null) {
                return;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return;
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setPaint(shapePaintable.getFillPaint());
            graphics2D.fill(shape);
            graphics2D.setPaint(shapePaintable.getDrawPaint());
            graphics2D.fill(shape2);
        }

        public XRect getActualBounds2D(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return new XRect();
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return new XRect();
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return new XRect();
            }
            XRect xRect = new XRect(shape.getBounds2D());
            XRect xRect2 = new XRect(shape2.getBounds2D());
            XRect xRect3 = xRect.createUnionRect(xRect2);
            return xRect3;
        }

        public Shape getOutline(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return null;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return null;
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return null;
            }
            Area area = new Area(shape);
            Area area2 = new Area(shape2);
            area.add(area2);
            return area;
        }

        public boolean originalContains(ShapePaintable shapePaintable, double d, double d2) {
            if (shapePaintable == null) {
                return false;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return false;
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return false;
            }
            return shape.contains(d, d2) || shape2.contains(d, d2);
        }

        /* synthetic */ 3() {
        }
    }
}

