/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.ErrorDialog;
import edu.neu.ccs.gui.GeneralView;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StringableFactory;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class GeneralViewSupport
implements JPTConstants {
    public static final String VIEW_STATE = "view.state";
    public static final String DEFAULT_VIEW_STATE = "default.view.state";
    public static final String DATA_TYPE = "data.type";
    public static final String FILTER = "filter";
    private GeneralView view = null;
    private EventListenerList listenerList = null;
    private JComponent component = null;
    private StringableFactory factory = new StringableFactory(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = GeneralViewSupport.class$("edu.neu.ccs.XString")));
    private InputProperties properties = new InputProperties();
    private StringableFilter filter = null;
    private String defaultViewState = "";
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$gui$MalformedDataListener;

    public GeneralViewSupport(GeneralView generalView, EventListenerList eventListenerList, Class clazz, String string, String string2, String string3) {
        if (generalView == null || eventListenerList == null) {
            throw new NullPointerException("Invalid null parameter to GeneralViewSupport constructor");
        }
        if (!(generalView instanceof JComponent)) {
            throw new IllegalArgumentException("View in GeneralViewSupport constructor is not JComponent");
        }
        this.view = generalView;
        this.listenerList = eventListenerList;
        this.component = (JComponent)((Object)generalView);
        this.setDataType(clazz);
        this.setErrorPromptTitleSuggestion(string, string2, string3);
    }

    public GeneralView getView() {
        return this.view;
    }

    public void setDataType(Class clazz) {
        Class clazz2 = this.getDataType();
        this.factory.setDataType(clazz);
        if (clazz2 != this.getDataType()) {
            this.component.firePropertyChange(DATA_TYPE, 0, 1);
        }
    }

    public Class getDataType() {
        return this.factory.getDataType();
    }

    public void setFilter(StringableFilter stringableFilter) {
        StringableFilter stringableFilter2 = this.getFilter();
        this.filter = stringableFilter;
        if (stringableFilter != stringableFilter2) {
            this.component.firePropertyChange(FILTER, 0, 1);
        }
    }

    public StringableFilter getFilter() {
        return this.filter;
    }

    public Stringable obtainObject(Stringable stringable) throws ParseException {
        block5: {
            if (stringable == null) {
                throw new ParseException("Null object in obtainObject", -1);
            }
            try {
                stringable.fromStringData(this.view.getViewState());
                if (this.filter == null) break block5;
                try {
                    stringable = this.filter.filterStringable(stringable);
                }
                catch (FilterException filterException) {
                    throw new ParseException(filterException.getMessage(), -1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), -1);
            }
        }
        return stringable;
    }

    public Stringable demandObject() {
        Stringable stringable = this.factory.getDefaultInstance();
        try {
            stringable = this.obtainObject(stringable);
        }
        catch (ParseException parseException) {
            this.handleError(stringable, 0, parseException);
            this.view.setViewState(stringable.toStringData());
            this.component.repaint();
        }
        return stringable;
    }

    public Stringable requestObject() throws CancelledException {
        Stringable stringable = this.factory.getDefaultInstance();
        try {
            stringable = this.obtainObject(stringable);
        }
        catch (ParseException parseException) {
            if (!this.handleError(stringable, 1, parseException)) {
                throw new CancelledException();
            }
            this.view.setViewState(stringable.toStringData());
            this.component.repaint();
        }
        return stringable;
    }

    public Stringable demandObject(StringableFilter stringableFilter) {
        StringableFilter stringableFilter2 = this.getFilter();
        this.setFilter(stringableFilter);
        Stringable stringable = this.demandObject();
        this.setFilter(stringableFilter2);
        return stringable;
    }

    public Stringable requestObject(StringableFilter stringableFilter) throws CancelledException {
        StringableFilter stringableFilter2 = this.getFilter();
        this.setFilter(stringableFilter);
        Stringable stringable = null;
        try {
            stringable = this.requestObject();
        }
        finally {
            Object var5_4 = null;
            this.setFilter(stringableFilter2);
        }
        return stringable;
    }

    public Stringable demandObject(Class clazz, StringableFilter stringableFilter) {
        Class clazz2 = this.factory.getDataType();
        this.factory.setDataType(clazz);
        StringableFilter stringableFilter2 = this.getFilter();
        this.setFilter(stringableFilter);
        Stringable stringable = this.demandObject();
        this.factory.setDataType(clazz2);
        this.setFilter(stringableFilter2);
        return stringable;
    }

    public Stringable requestObject(Class clazz, StringableFilter stringableFilter) throws CancelledException {
        Class clazz2 = this.factory.getDataType();
        this.factory.setDataType(clazz);
        StringableFilter stringableFilter2 = this.getFilter();
        this.setFilter(stringableFilter);
        Stringable stringable = null;
        try {
            stringable = this.requestObject();
        }
        finally {
            Object var7_6 = null;
            this.factory.setDataType(clazz2);
            this.setFilter(stringableFilter2);
        }
        return stringable;
    }

    public void setInputProperties(InputProperties inputProperties) {
        if (inputProperties == null) {
            inputProperties = InputProperties.BASE_PROPERTIES;
        }
        InputProperties inputProperties2 = this.getInputProperties();
        this.properties = inputProperties;
        if (inputProperties != null && !inputProperties.equals(inputProperties2)) {
            this.component.firePropertyChange("input.properties", 0, 1);
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public void setErrorPromptTitleSuggestion(String string, String string2, String string3) {
        this.properties.setInputPrompt(string);
        this.properties.setDialogTitle(string2);
        this.properties.setSuggestion(string3);
    }

    public void setDefaultViewState(String string) {
        String string2 = this.defaultViewState;
        this.defaultViewState = string = string == null ? "" : string;
        if (!string2.equals(this.defaultViewState)) {
            this.component.firePropertyChange(DEFAULT_VIEW_STATE, 0, 1);
        }
    }

    public String getDefaultViewState() {
        return this.defaultViewState;
    }

    public void reset() {
        this.view.setViewState(this.getDefaultViewState());
    }

    public void addMalformedDataListener(MalformedDataListener malformedDataListener) {
        this.listenerList.add(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = GeneralViewSupport.class$("edu.neu.ccs.gui.MalformedDataListener")), malformedDataListener);
    }

    public void removeMalformedDataListener(MalformedDataListener malformedDataListener) {
        this.listenerList.remove(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = GeneralViewSupport.class$("edu.neu.ccs.gui.MalformedDataListener")), malformedDataListener);
    }

    protected boolean handleError(Stringable stringable, int n, ParseException parseException) {
        this.fireDataMalformed(new MalformedDataEvent(this.view, this.view.getViewState(), parseException));
        InputProperties inputProperties = new InputProperties(this.properties);
        if (n != 1) {
            n = 0;
        }
        inputProperties.setInputModel(n);
        GeneralView generalView = this.view.makeCopy();
        generalView.setInputProperties(inputProperties);
        ErrorDialog errorDialog = new ErrorDialog(stringable, generalView, this.filter, parseException);
        ((Component)errorDialog).setVisible(true);
        this.fireDataMalformed(new MalformedDataEvent((Object)this.view, this.view.getViewState()));
        return errorDialog.wasCancelled() ^ true;
    }

    protected void fireDataMalformed(MalformedDataEvent malformedDataEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] != null && objectArray[n].equals(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : GeneralViewSupport.class$("edu.neu.ccs.gui.MalformedDataListener"))) {
                MalformedDataListener malformedDataListener = (MalformedDataListener)objectArray[n + 1];
                malformedDataListener.dataMalformed(malformedDataEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

