/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

public class ClippingWrapper
extends AbstractPaintable {
    private Paintable paintable = null;
    private Shape clippingshape = null;

    public ClippingWrapper() {
    }

    public ClippingWrapper(Paintable paintable) {
        this.setPaintable(paintable);
    }

    public ClippingWrapper(Paintable paintable, Shape shape) {
        this.setPaintable(paintable);
        this.setClippingShape(shape);
    }

    public final void originalPaint(Graphics graphics) {
        if (this.paintable == null || graphics == null || !this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.clippingshape != null) {
            graphics2D.clip(this.clippingshape);
        }
        this.paintable.paint(graphics2D);
    }

    public final XRect getActualBounds2D() {
        if (this.paintable == null) {
            return null;
        }
        XRect xRect = this.paintable.getBounds2D();
        if (this.clippingshape != null) {
            XRect xRect2 = new XRect(this.clippingshape.getBounds2D());
            xRect = xRect.createIntersectionRect(xRect2);
        }
        double d = xRect.getWidth();
        double d2 = xRect.getHeight();
        if (d <= 0.0 || d2 <= 0.0) {
            return null;
        }
        return xRect;
    }

    public final boolean originalContains(double d, double d2) {
        if (this.paintable == null) {
            return false;
        }
        if (this.clippingshape == null) {
            return this.paintable.contains(d, d2);
        }
        return this.paintable.contains(d, d2) && this.clippingshape.contains(d, d2);
    }

    public final void setPaintable(Paintable paintable) {
        if (paintable == this.paintable) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintable, paintable);
        this.paintable = paintable;
        this.firePropertyChange("set.paintable", null, null);
    }

    public final Paintable getPaintable() {
        return this.paintable;
    }

    public final void setClippingShape(Shape shape) {
        if (shape == this.clippingshape) {
            return;
        }
        this.removeAndAddForwardingListener(this.clippingshape, shape);
        this.clippingshape = shape;
        this.firePropertyChange("set.clipping.shape", null, null);
    }

    public final Shape getClippingShape() {
        return this.clippingshape;
    }
}

