/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionWrapper;
import edu.neu.ccs.gui.DisplayPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;

public class ActionsPanel
extends DisplayPanel {
    private Hashtable map = new Hashtable();

    public ActionsPanel() {
    }

    public ActionsPanel(LayoutManager layoutManager) {
        this(null, null, layoutManager);
    }

    public ActionsPanel(Action[] actionArray) {
        this(actionArray, null, null);
    }

    public ActionsPanel(Action[] actionArray, LayoutManager layoutManager) {
        this(actionArray, null, layoutManager);
    }

    public ActionsPanel(Action[] actionArray, Object[] objectArray, LayoutManager layoutManager) {
        if (layoutManager != null) {
            this.setLayout(layoutManager);
        }
        this.addActions(actionArray, objectArray);
    }

    public JButton addAction(Action action) {
        return this.addAction(action, null);
    }

    public JButton addAction(Action action, Object object) {
        if (action == null) {
            return null;
        }
        JButton jButton = new JButton(action);
        this.map.put(action, jButton);
        this.map.put(jButton, action);
        this.add((Component)jButton, object);
        return jButton;
    }

    public JButton[] addActions(Action[] actionArray) {
        return this.addActions(actionArray, null);
    }

    public JButton[] addActions(Action[] actionArray, Object[] objectArray) {
        if (actionArray == null) {
            return null;
        }
        int n = actionArray.length;
        int n2 = objectArray != null ? objectArray.length : -1;
        JButton[] jButtonArray = new JButton[n];
        int n3 = 0;
        while (n3 < n) {
            if (actionArray[n3] != null) {
                jButtonArray[n3] = n3 < n2 ? this.addAction(actionArray[n3], objectArray[n3]) : this.addAction(actionArray[n3], null);
            }
            ++n3;
        }
        return jButtonArray;
    }

    public Action getAction(JButton jButton) {
        if (jButton == null) {
            return null;
        }
        return (Action)this.map.get(jButton);
    }

    public JButton getButton(Action action) {
        if (action == null) {
            return null;
        }
        return (JButton)this.map.get(action);
    }

    public Action[] getActions() {
        JButton[] jButtonArray = this.getActionButtons();
        if (jButtonArray == null) {
            return null;
        }
        int n = jButtonArray.length;
        Action[] actionArray = new Action[n];
        int n2 = 0;
        while (n2 < n) {
            actionArray[n2] = (Action)this.map.get(jButtonArray[n2]);
            ++n2;
        }
        return actionArray;
    }

    public JButton[] getActionButtons() {
        Vector<Component> vector = new Vector<Component>();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JButton && this.map.containsKey(componentArray[n])) {
                vector.add(componentArray[n]);
            }
            ++n;
        }
        return vector.toArray(new JButton[0]);
    }

    public Action findMatchedAction(Action action) {
        if (action == null) {
            return null;
        }
        if (this.map.containsKey(action)) {
            return action;
        }
        Action action2 = ActionWrapper.getBaseAction(action);
        Action[] actionArray = this.getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (action2 == ActionWrapper.getBaseAction(actionArray[n])) {
                return actionArray[n];
            }
            ++n;
        }
        return null;
    }

    public JButton findMatchedButton(Action action) {
        return this.getButton(this.findMatchedAction(action));
    }

    public Action findMatchedAction(String string) {
        if (string == null) {
            return null;
        }
        Action[] actionArray = this.getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (string.equals((String)actionArray[n].getValue("Name"))) {
                return actionArray[n];
            }
            ++n;
        }
        return null;
    }

    public JButton findMatchedButton(String string) {
        return this.getButton(this.findMatchedAction(string));
    }

    public void setDefaultButton(JButton jButton) {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(jButton);
        }
    }

    public void setDefaultButton(Action action) {
        this.setDefaultButton(this.findMatchedButton(action));
    }

    public void setDefaultButton(String string) {
        this.setDefaultButton(this.findMatchedButton(string));
    }

    public static void setText(Action action, String string) {
        if (action == null) {
            return;
        }
        action.putValue("Name", string);
    }

    public static void setIcon(Action action, Icon icon) {
        if (action == null) {
            return;
        }
        action.putValue("SmallIcon", icon);
    }

    public static void setToolTipText(Action action, String string) {
        if (action == null) {
            return;
        }
        action.putValue("ShortDescription", string);
    }

    public static String getText(Action action) {
        if (action == null) {
            return null;
        }
        Object object = action.getValue("Name");
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static Icon getIcon(Action action) {
        if (action == null) {
            return null;
        }
        Object object = action.getValue("SmallIcon");
        if (object instanceof Icon) {
            return (Icon)object;
        }
        return null;
    }

    public static String getToolTipText(Action action) {
        if (action == null) {
            return null;
        }
        Object object = action.getValue("ShortDescription");
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }
}

