/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;

public class AbsoluteLayout
implements LayoutManager2 {
    protected Vector components = new Vector();

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (component == null) {
            return;
        }
        this.components.add(component);
    }

    public void removeLayoutComponent(Component component) {
        if (component != null) {
            this.components.remove(component);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        int n = 0;
        while (n < this.components.size()) {
            serializable = (Component)this.components.get(n);
            rectangle2 = AbsoluteLayout.getPreferredBounds((Component)serializable);
            rectangle = rectangle == null ? rectangle2 : rectangle.union(rectangle2);
            ++n;
        }
        if (rectangle == null) {
            return new Dimension();
        }
        serializable = container.getInsets();
        if (serializable == null) {
            serializable = new Insets(0, 0, 0, 0);
        }
        int n2 = rectangle.width + serializable.left + serializable.right;
        int n3 = rectangle.height + serializable.top + serializable.bottom;
        return new Dimension(n2, n3);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int n = insets.left;
        int n2 = insets.top;
        int n3 = 0;
        while (n3 < this.components.size()) {
            Component component = (Component)this.components.get(n3);
            if (component != null) {
                Rectangle rectangle = AbsoluteLayout.getPreferredBounds(component);
                rectangle.x += n;
                rectangle.y += n2;
                component.setBounds(rectangle);
            }
            ++n3;
        }
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        container.repaint();
    }

    public static Rectangle getPreferredBounds(Component component) {
        if (component == null) {
            return new Rectangle();
        }
        Point point = component.getLocation();
        Rectangle rectangle = component.getBounds();
        rectangle.x = point.x;
        rectangle.y = point.y;
        if (component instanceof Container) {
            Container container = (Container)component;
            Dimension dimension = container.getPreferredSize();
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
        } else {
            Dimension dimension = component.getMinimumSize();
            Dimension dimension2 = component.getSize();
            rectangle.width = Math.max(dimension.width, dimension2.width);
            rectangle.height = Math.max(dimension.height, dimension2.height);
        }
        return rectangle;
    }
}

