/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XRoundRect;
import edu.neu.ccs.util.JPTConstants;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public class XRoundSquare
extends XRoundRect
implements Serializable,
Stringable,
JPTConstants {
    private static String[] BLANK = new String[]{"", "", "", ""};
    private static String[] XYRArc = new String[]{"xc", "yc", "r", "arcr"};
    public static final String standardMessage = "\nXRoundSquare Error: Data format must be\n[...;...;...;...]\n[xc=...;yc=...;r=...;arcr=...]\nwhere ... stands for\nthe center data xc,yc,\nthe inner radius r,\nand the arc radius arcr\n";
    private double r;
    private double arcr;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XRoundSquare() {
    }

    public XRoundSquare(double xc, double yc, double r, double arcr) {
        this.setXYRArc(xc, yc, r, arcr);
    }

    public XRoundSquare(double r, double arcr) {
        this.setXYRArc(0.0, 0.0, r, arcr);
    }

    public XRoundSquare(XRoundSquare roundsquare) {
        this.setRoundSquare(roundsquare);
    }

    public String toString() {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        return "XRoundSquare[xc=" + xc + ";yc=" + yc + ";r=" + this.r + ";arcr=" + this.arcr + "]";
    }

    public String toStringData() {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        return "[" + xc + ";" + yc + ";" + this.r + ";" + this.arcr + "]";
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (strings.length != 4) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (!Arrays.equals(names, BLANK) && !Arrays.equals(names, XYRArc)) {
            throw new ParseException(standardMessage, -1);
        }
        names = XYRArc;
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XRoundSquare", (String[])names);
        }
        this.setXYRArc(result[0], result[1], result[2], result[3]);
    }

    public void setXYRArc(double xc, double yc, double r, double arcr) {
        r = Math.abs(r);
        arcr = (arcr = Math.abs(arcr)) > r ? r : arcr;
        this.r = r;
        this.arcr = arcr;
        double d = 2.0 * r;
        double arcd = 2.0 * arcr;
        super.setXYWHArcs(xc - r, yc - r, d, d, arcd, arcd);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setRoundSquare(XRoundSquare roundsquare) {
        if (roundsquare == null) {
            return;
        }
        double xc = roundsquare.getCenterX();
        double yc = roundsquare.getCenterY();
        double r = roundsquare.getRadius();
        double arcr = roundsquare.getArcRadius();
        this.setXYRArc(this.x, this.y, r, arcr);
    }

    public double getRadius() {
        return this.r;
    }

    public double getArcRadius() {
        return this.arcr;
    }

    public void setXYWHArcs(double x, double y, double w, double h, double arcw, double arch) {
    }

    public void move(double dx, double dy) {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        double r = this.getRadius();
        double arcr = this.getArcRadius();
        this.setXYRArc(this.x + dx, this.y + dy, r, arcr);
    }

    public void move(Point2D p) {
        if (p == null) {
            return;
        }
        this.move(p.getX(), p.getY());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

