import world.*;

import java.util.Random;

// This class represents the UFO object in the game.
class UFO {
  Posn loc; // Position of the middle of the UFO

  UFO(Posn loc) {
    this.loc = loc;
  }

  // Checks to see if the UFO is still within the bounds of the world
  // after moving and if so, returns a new one that's moved the appropriate
  // distance.  If it would move outside the left or right of the world,
  // then we only change the y.  If it would move below the world, then
  // we don't move at all.
  UFO move(int diffx, int diffy, int width, int height) {
     if((0 < (this.loc.y + diffy)) && ((this.loc.y + diffy) < height))
       if((0 < (this.loc.x + diffx)) && ((this.loc.x + diffx) < width))
         return new UFO(new Posn(this.loc.x + diffx, this.loc.y + diffy));
       else  
         return new UFO(new Posn(this.loc.x, this.loc.y + diffy));
     else return this;
  }

  // Given n, we pick (randomly) a distance to move horizontally whose absolute
  // value is <= n.  We also move the UFO down by 10 pixels.
  //
  // width and height are the dimensions of the world, which we use in move().
  UFO moveRandom(int n, int width, int height) {
    return this.move((- n + new Random().nextInt(2 * n + 1)), 10, width, height);
  }

  // bb() returns the bounding box for this UFO.  Since this.loc represents
  // the middle of the UFO, we need to adjust it for the bounding box, whose
  // loc is in the upper left.
  BoundingBox bb() {
    return new BoundingBox(new Posn(this.loc.x - 10, this.loc.y - 5), 20, 10);
  }

  // draw() draws the UFO to the world.  UFOs look like flying saucers --
  // they have a spherical body with a halo-like disk.  Of course, we're seeing
  // these UFOs on edge-wise so we use a circle for the body and a rectangle for
  // the disk.
  boolean draw(World w) {
    return w.theCanvas.drawDisk(this.loc, 5, new Blue())
        && w.theCanvas.drawRect(new Posn(this.loc.x - 10, this.loc.y - 2), 20, 4, new Green());
  }

  // Test and see if two UFOs are the same -- we can use this to test move().
  boolean same(UFO u) {
    return this.loc.x == u.loc.x &&
           this.loc.y == u.loc.y;
  } 
}
