/*
 * @(#)BalloonControl.java  17 March 2004
 *
 * @author Viera K. Proulx
 */

import java.awt.*;

import edu.neu.ccs.util.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.gui.*;

/** An input channel to return Balloon object from GUI input. */
class BalloonControl extends DisplayPanel
implements ConsoleAware, JPTConstants{
  
  /*--------------------------------------------------------------
   Member data
   *------------------------------------------------------------*/
  
  /** The GUI for user input for Ballon information --- the View*/
  public BalloonInputView bView;
  
  /** The Balloon object --- the Model*/
  public Balloon b = new Balloon();
  
  /** The panel that holds the graphics window for painting the balloon */
  public BufferedPanel window;
  
  /** The paint action. */
  protected SimpleAction paintAction =
    new SimpleAction("Paint") {
    public void perform() { 
      paintAction();
    }
  };
  
  /** The newBalloon action. */
  protected SimpleAction newAction =
    new SimpleAction("New") {
    public void perform() { 
      newAction();
    }
  };
  
  /** The cancel action. */
  protected SimpleAction cancelAction =
    new SimpleAction("Cancel") {
    public void perform() { cancelAction(); }
  };
  
  /*--------------------------------------------------------------
   Constructor
   *------------------------------------------------------------*/
  BalloonControl(BufferedPanel window){	
    
    this.window = window;	
    
    // build the GUI for input of one Balloon object
    this.bView = new BalloonInputView();
    TablePanel tp = new TablePanel(new Object[]{this.bView, 
        this.paintAction, 
        this.newAction, 
        this.cancelAction},
        VERTICAL);
    
    add(tp);								 
  }
  
  /*--------------------------------------------------------------
   Methods
   *------------------------------------------------------------*/
  protected void newAction(){
    this.b = this.bView.demandBalloon();
    console.out.println(this.b); 	
  }
  
  protected void paintAction(){
    this.b.paintBalloon(this.window); 	
  }
  
  protected void cancelAction(){
    console.out.println("close");
  }
  
  
}
