/*
 * @(#)Balloon.java  1.0  30 July 2002
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.gui.*;	// to get BufferedPanel
import java.awt.*;			// to get Color
import java.awt.geom.*;		// to get Graphics2D functionality

/** A simple class to use for learning about classes and objects. */
class Balloon {
  
  /*-------------------------------------------------------------------------
   Member data 
   *-----------------------------------------------------------------------*/
  
  /** center of the balloon */
  int x;
  int y;
  
  /** the radius of the balloon */
  int radius;
  
  /** the color of the balloon */
  Color c;
  
  /*-------------------------------------------------------------------------
   Constructor
   *-----------------------------------------------------------------------*/
  
  public Balloon (int some_x, int some_y, int some_radius, Color some_color){
    this.x = some_x;
    this.y = some_y;
    this.radius = some_radius;
    this.c = some_color;
  }
  
  /** copy constructor */
  public Balloon(Balloon someBalloon){
    this.x      = someBalloon.x;
    this.y      = someBalloon.y;
    this.radius = someBalloon.radius;
    this.c      = new Color(someBalloon.c.getRGB());
  }
  
  /** move the balloon by a given distance in both directions */
  Balloon moveBalloon(int dx, int dy){
    
    return new Balloon(this.x + dx, this.y + dy, this.radius, this.c);
  }
  
  /** default constructor */
  public Balloon(){
    this.x      = 200;
    this.y      = 150;
    this.radius = 45;
    this.c      = Color.red;
  }
  
  /*-------------------------------------------------------------------------
   Methods 
   *-----------------------------------------------------------------------*/
  
  /** compute the diameter of the balloon */
  int getDiameter(){
    return 2 * this.radius;
  }
  
  /** compute the distance of this balloon from the top of window */
  int distanceFromTop(){
    return this.y - this.radius;
  }
  
  /** compare the top of this and the given other balloon */
  boolean isHigherThan(Balloon otherBln){
    return this.distanceFromTop() < otherBln.distanceFromTop() ;
  }
  
  
  /** show balloon in the given buffered panel window */
  void paintBalloon(BufferedPanel window){
    
    if (window == null)
      return;
    
    // get graphics context and set the color
    Graphics2D G = window.getBufferGraphics();
    G.setPaint(this.c);
    
    // paint the ballon
    Ellipse2D.Double E = 
      new Ellipse2D.Double(this.x - this.radius, this.y - this.radius, 
          getDiameter(), getDiameter());
    G.fill(E);
    
    // paint the string
    Line2D.Double L =
      new Line2D.Double(this.x, this.y + this.radius, 
          this.x, this.y + 3 * this.radius);
    G.draw(L);
    window.repaint();
  }
  
  /** override equals */
  public boolean equals(Object obj){
    if (obj instanceof Balloon)
      return
      this.x == ((Balloon)obj).x &&
      this.y == ((Balloon)obj).y &&
      this.radius == ((Balloon)obj).radius &&
      this.c.equals(((Balloon)obj).c);
    else
      return false;
  }
  
  /** override hashCode */
  public int hashCode(){
    return 37 * (37 * (37 * this.x + this.y) + this.radius) 
    + this.c.hashCode();
  }
  
  
  /** print the balloon data */
  public String toString(){
    return ("new " + getClass() + "(" + 
        this.x + ", " + 
        this.y + ", " + 
        this.radius + ", " + 
        this.c + ")");
  }
  
}
