/* --------------------------------------------------------------------
 * Data Examples and Test Suite
 * Lab 10: 21 March 2006
 */

import java.util.*;

public class Examples extends TraversalTestHarness{
  
    // Sample Data
    Album soul1 = new Album("Let's Get It On", "Marvin Gaye", 1973);
    Album pop1 = new Album("Purple Rain", "Prince", 1984);
    Album rock1 = new Album("Are You Experienced", "Jimi Hendrix", 1966);
    Album jazz1 = new Album("Miles Smiles", "Miles Davis", 1966);
    ArrayList<Album> albums = new ArrayList<Album>();
    
    Algorithms algs = new Algorithms();
    
    // add the albums to the list
    private void makeList(){
      albums.add(soul1);
      albums.add(pop1);
      albums.add(rock1);
      albums.add(jazz1);
    }
    
    // tests for the orMap method variants
    private void testOrMaps(){
      makeList();
      
      // expected true:
      test("orMap using ArrayListTraversal",
          true, 
          algs.orMap(new AlbumListTraversal(albums, 0), 
              new BeforeYear(1970)));
      
      test("orMap using while loop with Traversal",
          true, 
          algs.orMapWhile(new AlbumListTraversal(albums, 0), 
              new BeforeYear(1970)));
      
      test("orMap using for loop with Traversal",
          true, 
          algs.orMapFor(new AlbumListTraversal(albums, 0), 
              new BeforeYear(1970)));
      
      test("orMap using counted for loop",
          true, 
          algs.orMapForCounted(albums, 
              new BeforeYear(1970)));

      // expected false:
      test("orMap using ArrayListTraversal",
          false, 
          algs.orMap(new AlbumListTraversal(albums, 0), 
              new BeforeYear(1950)));
      
      test("orMap using while loop with Traversal",
          false, 
          algs.orMapWhile(new AlbumListTraversal(albums, 0), 
              new BeforeYear(1950)));
      
      test("orMap using for loop with Traversal",
          false, 
          algs.orMapFor(new AlbumListTraversal(albums, 0), 
              new BeforeYear(1950)));
      
      test("orMap using counted for loop",
          false, 
          algs.orMapForCounted(albums, 
              new BeforeYear(1950)));
    }

    // tests for the mutating methods
      private void testMutation(){
          ArrayList<Album> albums = new ArrayList<Album>();
          Album unknown;
          
          //inserts the element at the end of the list
          albums.add(soul1);
          //behaves like cons, inserts the element at the beginning of the list
          albums.add(0, rock1);
          test("contains soul1?", true, albums.contains(soul1));
          test("is the albums list empty?", false, albums.isEmpty());
          
          test("is rock1 the 1st element?", true, rock1.equals(albums.get(0)));
          
          //set changes the object in the given index and 
          //returns the object that was there
          unknown = albums.set(1, pop1);
          test("is pop1 the 2nd element?", true, pop1.equals(albums.get(1)));
          test("before that, was soul1 the 2nd element?", true, soul1.equals(unknown));
          
          albums.add(jazz1);
          test("3 albums in the list?", 3, albums.size());
          
          albums.remove(jazz1);
          test("2 albums in the list?", 2, albums.size());
      }
      
    
      public static void main(String[] args) {
          Examples e = new Examples();
          
          e.testOrMaps();
          e.testMutation();
          

          e.fullTestReport();
      }

  
}

class BeforeYear implements ISelect<Album>{
  int year;
  
  BeforeYear(int year){
    this.year = year;
  }
  
  public boolean select(Album album){
    return album.getYor() < year;
  }
}
