/* Class to represent a traversal over a list of recording albums
 * -- using ArrayList as the list data structure
 * Lab 10: 21 March 2006
 */

import java.util.ArrayList;


public class AlbumListTraversal implements ETraversal<Album> {
  private ArrayList<Album> alist;
  private int index;
  
  /* full constructor */
  public AlbumListTraversal(ArrayList<Album> alist, int index){
    this.alist = alist;
    if (index <= this.alist.size()) 
      this.index = index;
    else 
      throw new RuntimeException("invalid index in the constructor");
  }
  
  /* Initializing constructor 
   * -- used to start the iterator for a given ArrayList
   */
  public AlbumListTraversal(ArrayList<Album> alist){
    this(alist, 0);
  }
  
  /*
   * the valid range is 0 <= index < size
   */
  public boolean hasMore() {
    return this.index < this.alist.size();
  }
  
  /*
   * produce the current album
   */
  public Album current() {
    if (this.hasMore())
      return this.alist.get(index);
    else
      throw new RuntimeException
      ("can't retrieve current from an empty list");
  }
  
  /*
   * produce iterator advanced to the next element
   */
  public ETraversal<Album> advance() {
    if (this.hasMore())
      return new AlbumListTraversal(this.alist, this.index + 1);
    else
      throw new RuntimeException
      ("can't advance further in an empty list");
  }
}
