/*
 * @(#)City.java  1.0  19 March 2006
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.gui.*;       // to get BufferedPanel
import edu.neu.ccs.*;           // to get XInt
import java.util.*;             // to get StringTokenizer
import java.text.*;
// to get ParseException

/** A simple class to use for learning about classes and objects. */
class City implements ISame, Stringable {

  /*-------------------------------------------------------------------------
   * Member data
   *-----------------------------------------------------------------------*/

  /** The zip code for this city. */
  public int zip;

  /** The name of this city. */
  public String name;

  /** The state for this city */
  public String state;

  /* The longitude for this city */
  public double longitude;

  /* The latitude for this city */
  public double latitude;

  /* Decimal format to print leading zeros in zip code */
  public DecimalFormat zipFormat = new DecimalFormat("00000");

  /*-------------------------------------------------------------------------
   * Constructor
   *-----------------------------------------------------------------------*/

  /* full constructor */
  public City (int zip, String name, String state,
               double longitude, double latitude) {
    this.zip   = zip;
    this.name  = name;
    this.state = state;
    this.longitude = longitude;
    this.latitude  = latitude;
  }

  /** copy constructor */
  public City(City aCity) {
    this(aCity.zip, aCity.name, aCity.state, aCity.longitude, aCity.latitude);
  }

  public City(String zip, String name, String state,
              double longitude, double latitude) {
    this.latitude = this.decimal(zip);
    this.name  = name;
    this.state = state;
    this.longitude = longitude;
    this.latitude  = latitude;
  }

  /** default constructor */
  public City() {
    this.zip   = 48170;
    this.name  = "Plymouth";
    this.state = "MI";
    this.longitude  = 83.479946;
    this.latitude = 42.368820;
  }

  /*-------------------------------------------------------------------------
   * Methods
   *-----------------------------------------------------------------------*/

  /** determine whether this city is in the given state */
  boolean isInState(String aState) {
    return this.state.equals(aState);
  }

  /*-------------------------------------------------------------------------
   * Stringable interface
   *-----------------------------------------------------------------------*/
  /** city data to string for file output*/
  public String toStringData() {
    String s = "" + this.zipFormat.format(this.zip) + ", "
                  + this.name      + ", "
                  + this.state     + ", "
                  + this.longitude + ", "
                  + this.latitude  + "\n";
    return s;
  }

  /*-------------------------------------------------------------------------
   * ISame interface
   *-----------------------------------------------------------------------*/
  /** determine whether this city is the same as the given object */
  public boolean same(Object obj) {
    return this.zip == ((City)obj).zip
        && this.name.equals(((City)obj).name)
        && this.state.equals(((City)obj).state)
        && this.sameDouble(this.longitude, ((City)obj).longitude, 0.000001)
        && this.sameDouble(this.latitude, ((City)obj).latitude, 0.000001);
  }

  /** helper method to compare doubles */
  protected boolean sameDouble(double d1, double d2, double limit) {
    return Math.abs(d1 - d2) < limit;
  }

  /** string to city data */
  public void fromStringData(String s) throws java.text.ParseException {

    try {
      /** set up the string tokenizer to extract city data */
      StringTokenizer st = new StringTokenizer(s, ",");

      this.zip       = decimal(st.nextToken());
      this.name      = st.nextToken();
      this.state     = st.nextToken();
      this.longitude = doubleValue(st.nextToken());
      this.latitude  = doubleValue(st.nextToken());
    } catch (NoSuchElementException e) {
      System.out.println(e.getMessage());
      throw new java.text.ParseException("Tokenizer Error", 0);
    }
  }

  /** convert a String to int - if possible */
  protected int intValue(String s) throws ParseException {
    return (new XInt(s)).intValue();
  }

  /** convert a String to double - if possible */
  protected double doubleValue(String s) throws ParseException {
    return (new XDouble(s)).doubleValue();
  }

  /*-------------------------------------------------------------------------
   * Console print
   *-----------------------------------------------------------------------*/
  /** print the city data */
  public String toString() {
    return ("new " + getClass() + "("
                   + this.zipFormat.format(this.zip) + ",   "
                   + this.name      + ",  "
                   + this.state     + ", "
                   + this.longitude + ", "
                   + this.latitude  + ")\n");
    }

  /** helper method to convert zip code string to integer */
  public int decimal(String s) {
    char[] c = s.toCharArray();
    int n = 0;
    try {
      for (int i = 0; i < 5; i++) {
        n = 10 * n + intValue("" + c[i]);
      }
    } catch (ParseException e) {
      System.out.println("Converting zip to int " + e);
    }
    return n;
  }

}
