/*
 * @(#)CityView.java  19 March 2006
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import javax.swing.*;

/**
 * View for input and manipulation of a City object.
 */
public class CityView
  implements JPTConstants {

  ///////////////
  // Constants //
  ///////////////

  /** Default label for the zip code text field view */
  public static final String DEFAULT_LABELz = "Zip Code:";

  /** Default label for the city name text field view */
  public static final String DEFAULT_LABELc = "City:";

  /** Default label for the state text field view */
  public static final String DEFAULT_LABELs = "State:";

  /** Default label for the longitude text field view */
  public static final String DEFAULT_LABELln = "Longitude:";

  /** Default label for the latitude text field view */
  public static final String DEFAULT_LABELlt = "Latitude:";

  /** Default layout orientation for the Point2DView . */
  public static final int DEFAULT_ORIENTATION = VERTICAL;

  /////////////////
  // Member Data //
  /////////////////

  /** Balloon number for reference */
  protected City c;

  /** The view to be used in input GUIs */
  public Display cView = new Display();

  /** Display field for the zip code. */
  protected TextFieldView zTFV;

  /** Display field for the city name. */
  protected TextFieldView cTFV;

  /** Display field for the state. */
  protected TextFieldView sTFV;

  /** Display field for the longitude code. */
  protected TextFieldView lnTFV;

  /** Display field for the latitude code. */
  protected TextFieldView ltTFV;

  /** Property list for this view object. */
  protected InputProperties properties = new InputProperties();

  public CityView() {
    super();

    /* record the information about this city */
    this.c = new City();

    // add the internal panel to the Display
    this.cView = new Display();
    this.cView.add(createDisplay());

    // set the title and annotation for the Display
    this.cView.setTitleText("City");

  }

  //////////////////////////////////
  // Helpers for the Constructors //
  //////////////////////////////////

  /**
   * Construct a table panel display for one city, containing
   * three text field views, sliders, and color view
   */
  protected TablePanel createDisplay() {

    createTFVset();

    TablePanel cityDisplay
      = new TablePanel(new Object[][]{{DEFAULT_LABELz,  this.zTFV},
                                      {DEFAULT_LABELc,  this.cTFV},
                                      {DEFAULT_LABELs,  this.sTFV},
                                      {DEFAULT_LABELln, this.lnTFV},
                                      {DEFAULT_LABELlt, this.ltTFV}},
                       VERTICAL, 5, 5);

    return cityDisplay;

  }

  /**
   * Creates four text field views with the desired default values
   */
  protected void createTFVset() {

    this.zTFV = new TextFieldView("" + 48170,
                                  "Please enter an integer:",
                                  "zip code error",80);
    this.cTFV = new TextFieldView("Plymouth", 80);
    this.sTFV = new TextFieldView("MI", 80);
    this.lnTFV = new TextFieldView("" + 83.479946,
                                   "Please enter a decimal number:",
                                   "area code error",
                                   80);
    this.ltTFV = new TextFieldView("" + 42.36882,
                                   "Please enter a decimal number:",
                                   "area code error",
                                   80);

    this.zTFV.setDefaultViewState("48170");
    this.cTFV.setDefaultViewState("Plymouth");
    this.sTFV.setDefaultViewState("MI");
    this.lnTFV.setDefaultViewState("" + 83.479946);
    this.ltTFV.setDefaultViewState("" + 42.36882);
  }

  /* set the view state from the current state of the city */
  public void setViewState() {
    this.zTFV.setViewState("" + this.c.zip);
    this.cTFV.setViewState("" + this.c.name);
    this.sTFV.setViewState("" + this.c.state);
    this.lnTFV.setViewState("" + this.c.longitude);
    this.ltTFV.setViewState("" + this.c.latitude);
  }

  public City getCity() {
    this.c.zip   = this.zTFV.demandInt();
    this.c.name  = this.cTFV.demandString();
    this.c.state = this.sTFV.demandString();
    this.c.longitude  = this.lnTFV.demandDouble();
    this.c.latitude = this.ltTFV.demandDouble();
    return this.c;
  }

}
