/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for a list of cities 
*/

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

/** An input iterator for Balloon object from GUI input. */
class InGuiTraversal implements Traversal {

    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    /* the display to install in the general dialog */
    protected Display cDisplay;
    
    /* the view for one city */
    protected CityView cView; 
    
    /* the general dialog for city input */
    protected GeneralDialog input;
    
    /* a city object to hold values */
    protected City c = new City();
    
    /* determines whether the general dialog has been closed */
    protected boolean closed = true;
    
    /* determines whether new baloon data has been submitted */
    protected boolean submitted = false;
    
    /** The submit action. */
    protected SimpleAction submitAction =
        new SimpleAction("Submit") {
            public void perform() { submitAction(); }
        };

    /** The cancel action. */
    protected SimpleAction cancelAction =
        new SimpleAction("Cancel") {
            public void perform() { cancelAction(); }
        };
    
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/
    public InGuiTraversal() { 

        this.cView = new CityView();    
        this.cDisplay = cView.cView;
        
        /* create non-modal dialog for balloon inputs */
        input = 
            new GeneralDialog
                 (cDisplay,
                  "City Input",
                  new Object[][]{{"Submit", submitAction, DialogAction.KEEP_OPEN},
                             {"Cancel", cancelAction, DialogAction.AUTO_CLOSE}},
                  false);
                  
        /* specify the closing action */
        input.setWindowClosingAction(cancelAction, DialogAction.AUTO_CLOSE);
        
        /* currently not closed */
        closed = false;   
        input.setVisible(true); 
        
        /* extract values for the first balloon */
        advance();
    }
        
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    /* nullify current data and wait for next submission */
    public synchronized void getnext() {
    
        submitted = false;
        while ((!submitted)&&(!closed)) JPTUtilities.pauseThread(10);
        if (closed)
            input.dispose();
    }
    
    public Traversal advance() {
      getnext();
      return this;
    }

    /* return the most recent submission - if available */
    public synchronized Object current() {
           
        if ((submitted) && (!closed))
            return c;
            
        else
            return null;
    }
    
    /* verify that new submission is available */
    public synchronized boolean hasMore() {
        return ((submitted) && (!closed)); 
    }
    
    
    /* save the balloon value for this submission */
    protected void submitAction(){
        c = cView.getCity();
        submitted = true;
    }
    
    /* register the closing action */
    protected void cancelAction(){
        closed = true;
   }
}
        
