/*
 * @(#)TraversalALC 22 March 2006
 *
 * @author Viera K. Proulx
 */

import java.util.ArrayList;
import java.util.NoSuchElementException;

/* ------------------------------------------------------------------
 A non-mutable iterator for a list of cities based on ArrayList 
 */
public class TraversalALC implements Traversal<City>{
  ArrayList<City> cities;
  int index;
  
  /*-------------------------------------------------------- 
  Constructors
  *------------------------------------------------------*/    
  public TraversalALC(ArrayList<City> cities, int index){
    if (index >= 0 && index <= cities.size()){
    this.cities = cities;
    this.index = index;
    }
    else
      throw new IndexOutOfBoundsException("In TraversalALC constructor");
  }
  
  public TraversalALC(ArrayList<City> cities){
    this(cities, 0);
  }
  
  /*--------------------------------------------------------
  Methods to implement the Traversal interface
  *------------------------------------------------------*/

  /* move the cursor one forward, if not at the end */
  public Traversal<City> advance(){
    if (this.hasMore())
      return new TraversalALC(this.cities, this.index + 1);
    else
      throw new NoSuchElementException(
      "Cannot advance beyond the last element in ArrayList");
  }
  
  /* select the item to which the cursor points */
  public City current(){
    if (this.hasMore())
      return this.cities.get(this.index);
    else
      throw new NoSuchElementException(
      "No current element after the last element in ArrayList");
  }
  
  /* test whether there are more items to traverse */
  public boolean hasMore(){
    return this.index < cities.size();
  }
  
  /*--------------------------------------------------------
  Self Test
  *------------------------------------------------------*/
  public static void main(String argv[]){
    City northville = 
      new City(48167, "Northville", "MI", 83.479355, 42.426245);
    City pinckney = 
      new City("48169", "Pinckney", "MI", 83.909918, 42.459579);
    City plymouth = 
      new City(48170, "Plymouth", "MI", 83.479946, 42.36882);
    City plymouth2 = new City();
    
    ArrayList<City> empty = new ArrayList<City>();
    ArrayList<City> alist = new ArrayList<City>();
    alist.add(northville);
    alist.add(pinckney);
    alist.add(plymouth);
    alist.add(plymouth2);
    
    Traversal<City> tr = new TraversalALC(alist);
    System.out.println("City list:");   
    while (tr.hasMore()){
      System.out.println(tr.current().toString());
      tr = tr.advance(); 
    }
    System.out.println("End of the list.");
    
    System.out.println("Examples of CitiesList-s:");
    System.out.println(empty.toString());
    System.out.println(alist.toString());
    
  }
  
}

