/*
 * @(#)TimerTests  1.0  22 March 2006
 *
 * @author Viera K. Proulx
 */

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;

import edu.neu.ccs.console.ConsoleAware;

class TimerTests implements ConsoleAware{
  
  
  Comparator<City> byName = new ComparatorByName();
  // Comparator<City> byZip = new ComparatorByZip();
  // Comparator<City> byLatitude = new ComparatorByLatitude();
  
  ASortAlgo selectarray = new ArrSortSelection(byName);;
  // ASortAlgo insertarray = new ArrSortInsertion();
  // ASortAlgo insertlist  = new AListSortInsertion();
  // ASortAlgo bstsort     = new ABinaryTreeSort();
  // ASortAlgo quicklist   = new AListSortQuickSort();
  // ASortAlgo quickarray  = new ArrSortQuickSort();
  
  
  // an arraylist of comparators to use
  ArrayList<Comparator> comparators = new ArrayList<Comparator>();
  
  // original data set of all cities available
  TestData testdata = new TestData();
  
  // records of the start and end time
  long startTime;         // time of the start of the test
  long endTime;           // time of the end of the test
  
  // constructor
  TimerTests(){ }
  
  
  // run one test of a given sorting algorithm
  // with the given comparator
  // and the desired size of data, random or sequentially selected
  public long runOneTest(ASortAlgo algo, DataSet dataset) {
    
    // select data to be sorted and record the information
    Traversal<City> source = dataset.getTraversal();
    int size = dataset.size;
    String type = dataset.type;
    
    // variable to record the result
    Traversal<City> result;
    
    // initialize the data for the algorithm
    algo.initData(source);
    
    // run the timed test and return the measured time
    this.startTime = (new Date()).getTime();
    result = algo.sort();
    this.endTime = (new Date()).getTime();
    return this.endTime - this.startTime;
  }
  
  // a sample test for this class
  public void sampleTest(){
    
    // example of running the test for one choice of
    // algorithm, data to sort, and comparator
    long runtime = this.runOneTest(
        new ArrSortSelection(this.byName), testdata.datasets.get(0));
    
    // we should print more info here - size of the data set,
    // is it random or sequential
    console.out.println("Selection sort ArrayList time: " + 
        runtime + "\n");
  }
  
  public static void main(String[] argv){
    TimerTests tt = new TimerTests();
    tt.sampleTest();
  }
}