/*
 * @(#)TestData  1.0  22 March 2006
 *
 * @author Viera K. Proulx
 */

import java.util.ArrayList;
import java.util.NoSuchElementException;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.util.MathUtilities;

/*
 * This class contains the test data for all sorting tests
 * For each data set size: 1000, 2000, 4000, 8000, 16000
 * there is a sequential and random set
 * For size 29470 there is just one complete set
 * 
 * sequential contains a contigous subset of the source data
 * random selects data at random from the source data
 */
class TestData implements ConsoleAware{
  
  // original data set of all cities available
  ArrayList<City> alldata = new ArrayList<City>();
  
  // 15 data sets for tests
  ArrayList<DataSet> datasets = new ArrayList<DataSet>(15);
  
  TestData(){
    for(Traversal<City>tr = new TraversalInFile();
        tr.hasMore();
        tr = tr.advance()){
      alldata.add(tr.current());
    }
    System.out.println("read initial data: " + alldata.size());
    buildDataSets();
  }
  
  public void buildDataSets(){
    datasets.add(new DataSet("sequential", 
        this.buildSequentialData(1000)));
    datasets.add(new DataSet("random", 
        this.buildSequentialData(1000)));
    datasets.add(new DataSet("sequential", 
        this.buildSequentialData(2000)));
    datasets.add(new DataSet("random", 
        this.buildSequentialData(2000)));
    datasets.add(new DataSet("sequential", 
        this.buildSequentialData(4000)));
    datasets.add(new DataSet("random", 
        this.buildSequentialData(4000)));
    datasets.add(new DataSet("random", 
        this.buildSequentialData(8000)));
    datasets.add(new DataSet("sequential", 
        this.buildSequentialData(8000)));
    datasets.add(new DataSet("random", 
        this.buildSequentialData(16000)));
    datasets.add(new DataSet("sequential", 
        this.buildSequentialData(16000)));
    datasets.add(new DataSet("random", 
        this.buildSequentialData(29460)));
    datasets.add(new DataSet("sequential", 
        this.buildSequentialData(29460)));
    
  }
  
  // create the base data set for all tests
  public void readData(){
    Traversal<City> tr = new TraversalInFile();
    this.alldata = new ArrayList(30000);
    for(;
    tr.hasMore();
    tr.advance()){
      alldata.add(tr.current());       
    }
    console.out.println("readData produced " + alldata.size() + " elements.");
  }
  
  // produce a random dataset size from original data
  public ArrayList<City> buildRandomData(int size){
    // make a copy of the original arraylist
    ArrayList<City> temp = (ArrayList)alldata.clone();
    ArrayList<City> result = new ArrayList<City>();
    
    if (size < temp.size()){
      
      // selecting elements at random index to add to the data set
      int index = 0;
      int loc;
      
      while (index < size){
        loc = MathUtilities.randomInt(0, temp.size() - 1);
        result.add(temp.get(loc));
        index = index + 1;
      }
    }
    console.out.println("Random data set of size " + 
        result.size() + " initialized.");
    return result;
  }
  
  // produce a sequential dataset of the given size from original data
  public ArrayList<City> buildSequentialData(int size){
    
    // reserve space for the new  arraylist
    ArrayList result = new ArrayList(size);
    
    if (size < this.alldata.size()){
      
      // selectat random the starting index for the data set
      int index = 0;
      int loc = MathUtilities.randomInt(0, this.alldata.size() - size);
      
      while (index < size){
        result.add(this.alldata.get(index + loc));
        index = index + 1;
      }
      console.out.println("Random data set of size " + 
          result.size() + " initialized.");
      return result;
    }
    else
      throw new NoSuchElementException(
          "data set of size " + size + "cannot be initialized");
  }
  
  
  
  public static void main(String[] argv){
    TestData testdata = new TestData();
    System.out.println("alldata size:  " + testdata.alldata.size());
    System.out.println("datasets size: " + testdata.datasets.size());
  }
}