/*
 * @(#)DataSet  1.0  22 March 2006
 *
 * @author Viera K. Proulx
 */

import java.util.ArrayList;

class DataSet{
  int size;             // the actual size of the data set
  String type;          // sequential, incremental, or random
  ArrayList<City> data; // the actual city data
  
  DataSet(int size, String type){
    // reserve enough space for the expected size
    this.data = new ArrayList<City>(size);
    // but set the actual size to zero
    this.size = 0;    // should grow to the given size
    // how is this data set constructed - include in the results
    this.type = type;
  }
 
  DataSet(String type, ArrayList<City> data){
    // use the given data
    this.data = data;
    // set the actual size
    this.size = data.size();    
    // how is this data set constructed - include in the results
    this.type = type;
  }
 
  // add the given city to this data set
  void add(City city){
    this.data.add(city);
    this.size = this.size + 1;
  }
  
  // provide an iterator for this data set
  Traversal<City> getTraversal(){
    return new TraversalALC(data);
  }
  
  /*--------------------------------------------------------
  Self Test
  *------------------------------------------------------*/
  public static void main(String argv[]){
    City northville = 
      new City(48167, "Northville", "MI", 83.479355, 42.426245);
    City pinckney = 
      new City("48169", "Pinckney", "MI", 83.909918, 42.459579);
    City plymouth = 
      new City(48170, "Plymouth", "MI", 83.479946, 42.36882);
    City plymouth2 = new City();
    
    DataSet dset = new DataSet(4, "random");
    
    dset.add(northville);
    dset.add(pinckney);
    dset.add(plymouth);
    dset.add(plymouth2);
    
    System.out.println("Examples of CitiesList-s:");
    Traversal tr = dset.getTraversal();
    
    while (tr.hasMore()){
      System.out.println(tr.current().toString());
      tr = tr.advance(); 
    }
    System.out.println("End of the list.");
  }
}
