/*
 * @(#)CitiesConsList  22 March 2006
 */

/**
 * Nonempty list of cities class
 */
public class CitiesConsList extends CitiesAList{
  
  /*---------------------------------------------------------------
   Member data
   --------------------------------------------------------------*/
  City         first;
  CitiesAList  rest;
  
  /*---------------------------------------------------------------
   Constructor
   --------------------------------------------------------------*/
  CitiesConsList (City s, CitiesAList r) {
    this.first = s;
    this.rest  = r;
  }
  
  /*---------------------------------------------------------------
   Interface ISame
   --------------------------------------------------------------*/
  public boolean same(CitiesAList alist){
    return alist.sameCitiesConsList(this);
  }
  
  public boolean sameCitiesConsList(CitiesConsList alist){
    return this.first.same(alist.first) &&
    this.rest.same(alist.rest);
  }
  /*---------------------------------------------------------------
   Print all member data values.
   --------------------------------------------------------------*/
  public String toString(){
    return("\nnew " + getClass().getName() + "(" + 
        first             + ", " + 
        rest   + ")");
  }
  /*---------------------------------------------------------------
   Self Test
   --------------------------------------------------------------*/
  public static void main(String argv[]){
    City northville = 
      new City(48167, "Northville", "MI", 83.479355, 42.426245);
    City pinckney = 
      new City("48169", "Pinckney", "MI", 83.909918, 42.459579);
    City plymouth = 
      new City(48170, "Plymouth", "MI", 83.479946, 42.36882);
    City plymouth2 = new City();
    
    CitiesAList empty = new CitiesMTList();
    CitiesAList alist = new CitiesConsList(northville,
        new CitiesConsList(pinckney,
            new CitiesConsList(plymouth,
                new CitiesConsList(plymouth2, empty))));
                    
    
    
    System.out.println("Examples of CitiesList-s:");
    System.out.println(empty.toString());
    System.out.println(alist.toString());
    
    System.out.println("Test same: " + plymouth2.same(plymouth));    
  }
  
}

