/*
 * @(#)ArrSortSelection  22 March 2006
 *
 * @author Viera K. Proulx
 */

import java.util.ArrayList;
import java.util.Comparator;


////////////////////////////////////////////////////////////////
// ArrayList Selection Sort
////////////////////////////////////////////////////////////////
class ArrSortSelection extends ASortAlgo{
  
  // data that will be sorted -- mutating sort
  ArrayList<City> data = new ArrayList<City>();
  
  ArrSortSelection(Comparator<City> comp, Traversal<City> tr){
    this.comp = comp;
    initData(tr);
  }
  
  ArrSortSelection(Comparator<City> comp){
    this.comp = comp;   
  }
  
  // initialize a data set with the data generated by the traversal
  public void initData(Traversal<City> tr){
    while (tr.hasMore()){
      data.add(tr.current());
      tr = tr.advance();
    }
  }
  
  // sort the data set with respect to the given comparator
  // produce a traversal for the sorted data
  public Traversal<City> sort(){
    int limit = data.size();
    for (int index = 0; index < limit; index = index + 1){
      swap(index, findMinIndex(index));
    }
    return new TraversalALC(data);
  }
  
  // swap two elements of the given ArrayList
  public void swap(int index1, int index2){
    City city1 = data.get(index1);
    data.set(index1, data.get(index2));
    data.set(index2, city1);
  }
  
  // find the index of the minimum element in this ArrayList
  // can assume it is not empty and low is a valid index
  public int findMinIndex(int low){
    int minindex = low;
    int limit = data.size();
    for (int index = low; index < limit; index = index + 1){
      if (comp.compare(data.get(index), data.get(minindex)) <= 0)
        minindex = index;
    }
    return minindex;
  }
  
  /*--------------------------------------------------------
  Self Test
  *------------------------------------------------------*/
  public static void main(String argv[]){
    City northville = 
      new City(48167, "Northville", "MI", 83.479355, 42.426245);
    City pinckney = 
      new City("48169", "Pinckney", "MI", 83.909918, 42.459579);
    City plymouth = 
      new City(48170, "Plymouth", "MI", 83.479946, 42.36882);
    City plymouth2 = new City();
    
    ArrayList<City> alist = new ArrayList<City>();
    alist.add(northville);
    alist.add(plymouth);
    alist.add(plymouth2);
    alist.add(pinckney);
    
    // just print the data
    System.out.println("Examples of CitiesList-s:");
    Traversal<City> tr = new TraversalALC(alist);
    while (tr.hasMore()){
      System.out.println(tr.current().toString());
      tr = tr.advance(); 
    }
    System.out.println("End of the list.");
    
    // sort the data and print it
    tr = new TraversalALC(alist);
    ArrSortSelection arrSelect = 
      new ArrSortSelection(new ComparatorByName(), tr);   
    
    // test minindex
    System.out.println("min index should be 0; actual " +
        arrSelect.findMinIndex(0));
    
    Traversal sorted = arrSelect.sort();
    
    
    System.out.println("Sorted list:");   
    while (sorted.hasMore()){
      System.out.println(sorted.current().toString());
      sorted = sorted.advance(); 
    }
    System.out.println("End of the list.");
  
    // test the swap
    System.out.println("Before swap:");   
    System.out.println("at 0: " + 
        arrSelect.data.get(0).toStringData());
    System.out.println("at 1: " + 
        arrSelect.data.get(1).toStringData());    
    
    arrSelect.swap(0, 1);
    
    System.out.println("After swap:");
    System.out.println("at 0: " + 
        arrSelect.data.get(0).toStringData());
    System.out.println("at 1: " + 
        arrSelect.data.get(1).toStringData());
    
    // test minindex
    System.out.println("min index should be 1; actual " +
        arrSelect.findMinIndex(0));
    
  }  
}